/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.swing;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import jmri.util.swing.JmriColorChooserPanel;

public class JmriColorChooser {
    private static ArrayList<Color> recentColors = new ArrayList();
    private static boolean _suppressAdd = false;
    static Color color;

    public static void addRecentColor(Color color) {
        if (color == null || _suppressAdd || !color.toString().contains("java.awt.Color")) {
            return;
        }
        if (!recentColors.contains(color)) {
            recentColors.add(color);
        }
    }

    public static void suppressAddRecentColor(boolean set) {
        _suppressAdd = set;
    }

    public static ArrayList<Color> getRecentColors() {
        return new ArrayList<Color>(recentColors);
    }

    public static Color showDialog(Component comp, String dialogTitle, Color currentColor) {
        color = currentColor == null ? Color.WHITE : currentColor;
        String title = dialogTitle == null ? "" : dialogTitle;
        JColorChooser chooser = JmriColorChooser.extendColorChooser(new JColorChooser(color));
        JDialog d = JColorChooser.createDialog(null, title, true, chooser, e -> {
            color = chooser.getColor();
        }, null);
        d.setVisible(true);
        return color;
    }

    public static JColorChooser extendColorChooser(JColorChooser chooser) {
        AbstractColorChooserPanel[] currPanels = chooser.getChooserPanels();
        int colorTabCount = currPanels.length + 1;
        AbstractColorChooserPanel[] newPanels = new AbstractColorChooserPanel[colorTabCount];
        newPanels[0] = new JmriColorChooserPanel();
        int idx = 1;
        for (int i = 0; i < currPanels.length; ++i) {
            if (currPanels[i].getDisplayName().equals("JMRI")) continue;
            newPanels[idx] = currPanels[i];
            ++idx;
        }
        chooser.setChooserPanels(newPanels);
        _suppressAdd = false;
        return chooser;
    }
}

