/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.swing;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Locale;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import jmri.util.swing.JDialogListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmriJOptionPane {
    public static final int CANCEL_OPTION = 2;
    public static final int OK_OPTION = 0;
    public static final int OK_CANCEL_OPTION = 2;
    public static final int YES_OPTION = 0;
    public static final int YES_NO_OPTION = 0;
    public static final int YES_NO_CANCEL_OPTION = 1;
    public static final int NO_OPTION = 1;
    public static final int CLOSED_OPTION = -1;
    public static final int DEFAULT_OPTION = -1;
    public static final Object UNINITIALIZED_VALUE = JOptionPane.UNINITIALIZED_VALUE;
    public static final int ERROR_MESSAGE = 0;
    public static final int INFORMATION_MESSAGE = 1;
    public static final int PLAIN_MESSAGE = -1;
    public static final int QUESTION_MESSAGE = 3;
    public static final int WARNING_MESSAGE = 2;
    public static final String YES_STRING = UIManager.getString((Object)"OptionPane.yesButtonText", Locale.getDefault());
    public static final String NO_STRING = UIManager.getString((Object)"OptionPane.noButtonText", Locale.getDefault());
    private static final Logger log = LoggerFactory.getLogger(JmriJOptionPane.class);

    protected JmriJOptionPane() {
    }

    public static void showMessageDialog(@CheckForNull Component parentComponent, Object message) throws HeadlessException {
        JmriJOptionPane.showMessageDialog(parentComponent, message, UIManager.getString((Object)"OptionPane.messageDialogTitle", Locale.getDefault()), 1);
    }

    public static void showMessageDialog(@CheckForNull Component parentComponent, Object message, String title, int messageType) {
        JmriJOptionPane.showOptionDialog(parentComponent, message, title, -1, messageType, null, null, null);
    }

    public static void showMessageDialogNonModal(@CheckForNull Component parentComponent, Object message, String title, int messageType, @CheckForNull Runnable callback) {
        JOptionPane pane = new JOptionPane(message, messageType);
        JDialog dialog = pane.createDialog(parentComponent, title);
        Window w = JmriJOptionPane.findWindowForComponent(parentComponent);
        if (w != null) {
            JDialogListener pcl = new JDialogListener(dialog);
            w.addPropertyChangeListener(pcl);
            pane.addPropertyChangeListener("value", unused -> w.removePropertyChangeListener(pcl));
        }
        if (callback != null) {
            pane.addPropertyChangeListener("value", unused -> callback.run());
        }
        JmriJOptionPane.setDialogLocation(parentComponent, dialog);
        dialog.setModal(false);
        dialog.setAlwaysOnTop(true);
        dialog.toFront();
        dialog.setVisible(true);
    }

    public static int showConfirmDialog(@CheckForNull Component parentComponent, Object message, String title, int optionType) throws HeadlessException {
        return JmriJOptionPane.showOptionDialog(parentComponent, message, title, optionType, 3, null, null, null);
    }

    public static int showConfirmDialog(@CheckForNull Component parentComponent, Object message, String title, int optionType, int messageType) throws HeadlessException {
        return JmriJOptionPane.showOptionDialog(parentComponent, message, title, optionType, messageType, null, null, null);
    }

    public static int showOptionDialog(@CheckForNull Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue) throws HeadlessException {
        log.debug("showOptionDialog comp {} ", (Object)parentComponent);
        JOptionPane pane = new JOptionPane(message, messageType, optionType, icon, options, initialValue);
        pane.setInitialValue(initialValue);
        JmriJOptionPane.displayDialog(pane, parentComponent, title);
        Object selectedValue = pane.getValue();
        if (selectedValue == null) {
            return -1;
        }
        if (options == null) {
            if (selectedValue instanceof Integer) {
                return (Integer)selectedValue;
            }
            return -1;
        }
        int maxCounter = options.length;
        for (int counter = 0; counter < maxCounter; ++counter) {
            if (!options[counter].equals(selectedValue)) continue;
            return counter;
        }
        return -1;
    }

    @CheckForNull
    public static String showInputDialog(@CheckForNull Component parentComponent, String message, String initialSelectionValue) {
        return (String)JmriJOptionPane.showInputDialog(parentComponent, message, UIManager.getString((Object)"OptionPane.inputDialogTitle", Locale.getDefault()), 3, null, null, initialSelectionValue);
    }

    @CheckForNull
    public static String showInputDialog(@CheckForNull Component parentComponent, String message, String title, int messageType) {
        return (String)JmriJOptionPane.showInputDialog(parentComponent, message, title, messageType, null, null, "");
    }

    @CheckForNull
    public static Object showInputDialog(@CheckForNull Component parentComponent, String message, Object initialSelectionValue) {
        return JmriJOptionPane.showInputDialog(parentComponent, message, UIManager.getString((Object)"OptionPane.inputDialogTitle", Locale.getDefault()), 3, null, null, initialSelectionValue);
    }

    @CheckForNull
    public static Object showInputDialog(@CheckForNull Component parentComponent, Object message, String title, int messageType, Icon icon, Object[] selectionValues, Object initialSelectionValue) throws HeadlessException {
        JOptionPane pane = new JOptionPane(message, messageType, 2, icon, null, initialSelectionValue);
        pane.setWantsInput(true);
        pane.setSelectionValues(selectionValues);
        pane.setInitialSelectionValue(initialSelectionValue);
        pane.selectInitialValue();
        JmriJOptionPane.displayDialog(pane, parentComponent, title);
        Object value = pane.getInputValue();
        if (value == UNINITIALIZED_VALUE) {
            return null;
        }
        return value;
    }

    private static void displayDialog(JOptionPane pane, Component parentComponent, String title) {
        pane.setComponentOrientation(JOptionPane.getRootFrame().getComponentOrientation());
        Window w = JmriJOptionPane.findWindowForComponent(parentComponent);
        JDialog dialog = pane.createDialog(parentComponent, title);
        JDialogListener pcl = new JDialogListener(dialog);
        if (w != null) {
            dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
            w.addPropertyChangeListener(pcl);
        }
        JmriJOptionPane.setDialogLocation(parentComponent, dialog);
        dialog.setAlwaysOnTop(true);
        dialog.toFront();
        dialog.setVisible(true);
        dialog.dispose();
        if (w != null) {
            w.removePropertyChangeListener(pcl);
        }
    }

    private static void setDialogLocation(@CheckForNull Component parentComponent, @Nonnull Dialog dialog) {
        int centreHeight;
        int centreWidth;
        log.debug("set dialog position for comp {} dialog {}", (Object)parentComponent, (Object)dialog.getTitle());
        Window w = JmriJOptionPane.findWindowForComponent(parentComponent);
        if (w == null || !w.isVisible()) {
            centreWidth = Toolkit.getDefaultToolkit().getScreenSize().width / 2;
            centreHeight = Toolkit.getDefaultToolkit().getScreenSize().height / 2;
        } else {
            Point topLeft = w.getLocationOnScreen();
            Dimension size = w.getSize();
            centreWidth = topLeft.x + size.width / 2;
            centreHeight = topLeft.y + size.height / 2;
        }
        int centerX = centreWidth - dialog.getWidth() / 2;
        int centerY = centreHeight - dialog.getHeight() / 2;
        dialog.setLocation(new Point(Math.max(0, centerX), Math.max(0, centerY)));
    }

    @CheckForNull
    private static Window findWindowForComponent(@CheckForNull Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof JPopupMenu) {
            return JmriJOptionPane.findWindowForComponent(((JPopupMenu)component).getInvoker());
        }
        if (component instanceof JFrame) {
            return (JFrame)component;
        }
        if (component instanceof Window) {
            return (Window)component;
        }
        return JmriJOptionPane.findWindowForComponent(component.getParent());
    }

    @CheckForNull
    public static Window findWindowForObject(@CheckForNull Object object) {
        if (object instanceof Component) {
            return JmriJOptionPane.findWindowForComponent((Component)object);
        }
        return null;
    }
}

