/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.swing;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import jmri.util.SystemType;

public class JmriMouseEvent {
    public static final int MOUSE_CLICKED = 500;
    public static final int MOUSE_PRESSED = 501;
    public static final int MOUSE_RELEASED = 502;
    public static final int MOUSE_MOVED = 503;
    public static final int MOUSE_ENTERED = 504;
    public static final int MOUSE_EXITED = 505;
    public static final int MOUSE_DRAGGED = 506;
    public static final int MOUSE_WHEEL = 507;
    public static final int NOBUTTON = 0;
    public static final int BUTTON1 = 1;
    public static final int BUTTON2 = 2;
    public static final int BUTTON3 = 3;
    private final MouseEvent event;

    public JmriMouseEvent(MouseEvent event) {
        this.event = event;
    }

    public JmriMouseEvent(Component source, int id, long when, int modifiers, int x, int y, int clickCount, boolean popupTrigger) {
        this.event = new MouseEvent(source, id, when, modifiers, x, y, clickCount, popupTrigger, 0);
    }

    public JmriMouseEvent(Component source, int id, long when, int modifiers, int x, int y, int clickCount, boolean popupTrigger, int button) {
        this.event = new MouseEvent(source, id, when, modifiers, x, y, clickCount, popupTrigger, button);
    }

    public int getID() {
        return this.event.getID();
    }

    public Point getLocationOnScreen() {
        return this.event.getLocationOnScreen();
    }

    public int getXOnScreen() {
        return this.event.getXOnScreen();
    }

    public int getYOnScreen() {
        return this.event.getYOnScreen();
    }

    public int getX() {
        return this.event.getX();
    }

    public int getY() {
        return this.event.getY();
    }

    public Point getPoint() {
        return this.event.getPoint();
    }

    public synchronized void translatePoint(int x, int y) {
        this.event.translatePoint(x, y);
    }

    public int getClickCount() {
        return this.event.getClickCount();
    }

    public int getButton() {
        return this.event.getButton();
    }

    public boolean isPopupTrigger() {
        if (SystemType.isWindows()) {
            switch (this.event.getID()) {
                case 500: 
                case 501: 
                case 502: {
                    return (this.event.getModifiersEx() & 0x100) != 0 || (this.event.getModifiersEx() & 0x1000) != 0;
                }
            }
            return this.event.isPopupTrigger();
        }
        return this.event.isPopupTrigger();
    }

    public static String getMouseModifiersText(int modifiers) {
        return MouseEvent.getMouseModifiersText(modifiers);
    }

    public String paramString() {
        return this.event.paramString();
    }

    public boolean isShiftDown() {
        return this.event.isShiftDown();
    }

    public boolean isControlDown() {
        return this.event.isControlDown();
    }

    public boolean isMetaDown() {
        if (SystemType.isWindows() || SystemType.isLinux()) {
            return (this.event.getModifiersEx() & 0x1000) != 0 || (this.event.getModifiersEx() & 0x100) != 0;
        }
        return this.event.isMetaDown();
    }

    public boolean isAltDown() {
        return this.event.isAltDown();
    }

    public boolean isAltGraphDown() {
        return this.event.isAltGraphDown();
    }

    public long getWhen() {
        return this.event.getWhen();
    }

    @Deprecated(since="9")
    public int getModifiers() {
        return this.event.getModifiers();
    }

    public int getModifiersEx() {
        return this.event.getModifiersEx();
    }

    public Component getComponent() {
        return this.event.getComponent();
    }

    public Object getSource() {
        return this.event.getSource();
    }

    public void consume() {
        this.event.consume();
    }
}

