/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.swing;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;

public class OvertypeTextArea
extends JTextField {
    private static boolean isOvertypeMode;
    private Caret defaultCaret;
    private Caret overtypeCaret;

    public OvertypeTextArea(int length) {
        super(length);
        this.setCaretColor(Color.red);
        this.defaultCaret = this.getCaret();
        this.overtypeCaret = new OvertypeCaret();
        this.overtypeCaret.setBlinkRate(this.defaultCaret.getBlinkRate());
        this.setOvertypeMode(false);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                OvertypeTextArea.this.setOvertypeMode(OvertypeTextArea.this.isOvertypeMode());
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
    }

    public boolean isOvertypeMode() {
        return isOvertypeMode;
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="GUI ease of use")
    public void setOvertypeMode(boolean isOvertypeModeArg) {
        isOvertypeMode = isOvertypeModeArg;
        int pos = this.getCaretPosition();
        if (this.isOvertypeMode()) {
            this.setCaret(this.overtypeCaret);
        } else {
            this.setCaret(this.defaultCaret);
        }
        this.setCaretPosition(pos);
    }

    @Override
    public void replaceSelection(String text) {
        if (this.isOvertypeMode()) {
            int pos = this.getCaretPosition();
            if (this.getSelectedText() == null && pos < this.getDocument().getLength()) {
                this.moveCaretPosition(pos + 1);
            }
        }
        super.replaceSelection(text);
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
        if (e.getID() == 402 && e.getKeyCode() == 155) {
            this.setOvertypeMode(!this.isOvertypeMode());
        }
    }

    private static class OvertypeCaret
    extends DefaultCaret {
        private OvertypeCaret() {
        }

        @Override
        public void paint(Graphics g) {
            if (this.isVisible()) {
                try {
                    JTextComponent component = this.getComponent();
                    TextUI mapper = component.getUI();
                    Rectangle r = mapper.modelToView(component, this.getDot());
                    g.setColor(component.getCaretColor());
                    int width = g.getFontMetrics().charWidth('w');
                    int y = r.y + r.height - 2;
                    g.drawLine(r.x, y, r.x + width - 2, y);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        @Override
        protected synchronized void damage(Rectangle r) {
            if (r != null) {
                JTextComponent component = this.getComponent();
                this.x = r.x;
                this.y = r.y;
                this.width = component.getFontMetrics(component.getFont()).charWidth('w');
                this.height = r.height;
                this.repaint();
            }
        }
    }
}

