/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.swing;

import com.alexandriasoftware.swing.JSplitButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JPopupMenu;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import jmri.util.swing.Bundle;
import jmri.util.swing.ColorListPopupMenu;

public class SplitButtonColorChooserPanel
extends AbstractColorChooserPanel {
    private JSplitButton setButton = null;
    private static final int ICON_DIMENSION = 20;

    @Override
    public void updateChooser() {
        Color color = this.getColorFromModel();
        BufferedImage image = new BufferedImage(20, 20, 1);
        Graphics g = image.getGraphics();
        g.setColor(color);
        g.fillRect(0, 0, 20, 20);
        g.setColor(Color.black);
        g.drawRect(0, 0, 19, 19);
        ImageIcon icon = new ImageIcon(image);
        this.setButton.setIcon((Icon)icon);
        this.setButton.setPopupMenu((JPopupMenu)new ColorListPopupMenu(this.getColorSelectionModel()));
        g.dispose();
    }

    @Override
    protected void buildChooser() {
        BufferedImage image = new BufferedImage(20, 20, 1);
        Graphics g = image.getGraphics();
        g.setColor(this.getColorFromModel());
        g.fillRect(0, 0, 20, 20);
        ImageIcon icon = new ImageIcon(image);
        g.dispose();
        this.setButton = new JSplitButton(Bundle.getMessage("SetColor") + "      ", (Icon)icon);
        this.setButton.addButtonClickedActionListener(e -> {
            Color desiredColor = JColorChooser.showDialog(this.setButton.getParent(), Bundle.getMessage("SetColor"), this.getColorFromModel());
            if (desiredColor != null) {
                this.getColorSelectionModel().setSelectedColor(desiredColor);
            }
        });
        this.setButton.addSplitButtonClickedActionListener(e -> {});
        this.setButton.setPopupMenu((JPopupMenu)new ColorListPopupMenu(this.getColorSelectionModel()));
        this.add((Component)this.setButton);
    }

    @Override
    public String getDisplayName() {
        return Bundle.getMessage("SplitButtonColorChooserName");
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }
}

