/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.swing;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.UIManager;
import jmri.util.swing.StayOpenCheckBoxMenuItemUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StayOpenCheckBoxItem
extends JCheckBoxMenuItem {
    private MenuElement[] path;
    private static final Set<String> LAFS = new HashSet<String>(Arrays.asList("Nimbus", "Mac OS X"));
    private static final Logger log = LoggerFactory.getLogger(StayOpenCheckBoxItem.class);

    public StayOpenCheckBoxItem(String text) {
        super(text);
        this.initUI();
    }

    public StayOpenCheckBoxItem(String text, boolean isSelected) {
        super(text, isSelected);
        this.initUI();
    }

    private void initUI() {
        this.putClientProperty("CheckBoxMenuItem.doNotCloseOnMouseClick", Boolean.TRUE);
        if (StayOpenCheckBoxItem.useWithLAF()) {
            this.setUI(new StayOpenCheckBoxMenuItemUI());
            this.getModel().addChangeListener(e -> {
                if (this.getModel().isArmed() && this.isShowing()) {
                    this.path = MenuSelectionManager.defaultManager().getSelectedPath();
                }
            });
        }
    }

    private static boolean useWithLAF() {
        String laf = UIManager.getLookAndFeel().getName();
        log.debug("Using LAF '{}'", (Object)laf);
        return !LAFS.contains(laf);
    }

    @Override
    public void doClick(int pressTime) {
        super.doClick(pressTime);
        if (StayOpenCheckBoxItem.useWithLAF()) {
            MenuSelectionManager.defaultManager().setSelectedPath(this.path);
        }
    }
}

