/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.swing;

import javax.annotation.Nonnull;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextAreaFIFO
extends JTextArea
implements DocumentListener {
    private int _maxLines;
    private Boolean _autoScroll;
    private static final Logger log = LoggerFactory.getLogger(TextAreaFIFO.class);

    public TextAreaFIFO(int lines) {
        this._maxLines = lines;
        this._autoScroll = true;
        this.getDocument().addDocumentListener(this);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        ThreadingUtil.runOnGUIEventually(() -> this.removeLines());
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        ThreadingUtil.runOnGUIEventually(() -> this.removeLines());
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        ThreadingUtil.runOnGUIEventually(() -> this.removeLines());
    }

    public void setAutoScroll(@Nonnull Boolean newval) {
        this._autoScroll = newval;
        if (this._autoScroll.booleanValue()) {
            ThreadingUtil.runOnGUIEventually(() -> this.removeLines());
        }
    }

    public void setMaxLines(int newval) {
        this._maxLines = newval;
    }

    private void removeLines() {
        Element root = this.getDocument().getDefaultRootElement();
        while (root.getElementCount() > this._maxLines + 1) {
            Element firstLine = root.getElement(0);
            try {
                this.getDocument().remove(0, firstLine.getEndOffset());
            }
            catch (BadLocationException ble) {
                log.error("bad location", (Throwable)ble);
            }
        }
        if (this._autoScroll.booleanValue()) {
            this.setCaretPosition(this.getDocument().getLength());
        }
    }

    public void dispose() {
        this.getDocument().removeDocumentListener(this);
    }
}

