/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.swing;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class ValidatedTextField
extends JTextField {
    ValidatedTextField thisone;
    private String lastQueryValue;
    private String validateRegExpr;
    private final Integer minAllowedValue;
    private final Integer maxAllowedValue;
    private final boolean allow0Length;
    private final String validationErrorText;
    private final FieldType fieldType;
    private final boolean forceUpper;
    private final MyVerifier verifier;
    private Color invalidBackgroundColor = null;
    public static final String VTF_PC_STAT_LN_UPDATE = "VTFPCK_STAT_LN_UPDATE";
    public static final Color COLOR_BG_EDITED = Color.orange;
    public static final Color COLOR_ERROR_VAL = Color.black;
    public static final Color COLOR_OK = Color.black;
    public static final Color COLOR_BG_OK;
    public static final Color COLOR_BG_UNEDITED;
    public static final Color COLOR_BG_ERROR;

    public ValidatedTextField(Integer len, boolean forceUppercase, String validationRegExpr, String validationErrorMessage) {
        super("0", len);
        this.fieldType = FieldType.TEXT;
        this.validateRegExpr = validationRegExpr;
        this.validationErrorText = "ERROR:" + validationErrorMessage;
        this.minAllowedValue = 0;
        this.forceUpper = forceUppercase;
        this.maxAllowedValue = 0;
        this.allow0Length = false;
        this.verifier = new MyVerifier();
        this.setInvalidBackgroundColor(COLOR_BG_ERROR);
        this.thisone = this;
        this.thisone.setInputVerifier(this.verifier);
        this.thisone.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                ValidatedTextField.this.setEditable(true);
                ValidatedTextField.this.setEnabled(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
                ValidatedTextField.this.exitFieldColorizer();
                ValidatedTextField.this.setEditable(true);
            }
        });
    }

    public ValidatedTextField(Integer len, boolean allow0LengthValue, boolean forceUppercase, Integer minValue, Integer maxValue, String validationRegExpr, String validationErrorMessage) {
        super("0", len);
        this.fieldType = FieldType.INTEGRALNUMERICPLUSSTRING;
        this.validateRegExpr = validationRegExpr;
        this.validationErrorText = "ERROR:" + validationErrorMessage;
        this.minAllowedValue = minValue;
        this.forceUpper = forceUppercase;
        this.maxAllowedValue = maxValue;
        this.allow0Length = allow0LengthValue;
        this.verifier = new MyVerifier();
        this.thisone = this;
        this.thisone.setInputVerifier(this.verifier);
        this.thisone.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                ValidatedTextField.this.setEditable(true);
                ValidatedTextField.this.setEnabled(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
                ValidatedTextField.this.exitFieldColorizer();
                ValidatedTextField.this.setEditable(true);
            }
        });
    }

    public ValidatedTextField(Integer len, boolean allow0LengthValue, Integer minValue, Integer maxValue, String validationErrorMessage) {
        super("0", len);
        this.validateRegExpr = null;
        this.validationErrorText = "ERROR:" + validationErrorMessage;
        this.fieldType = FieldType.INTEGRALNUMERIC;
        this.minAllowedValue = minValue;
        this.maxAllowedValue = maxValue;
        this.forceUpper = false;
        this.allow0Length = allow0LengthValue;
        this.verifier = new MyVerifier();
        this.thisone = this;
        this.thisone.setInputVerifier(this.verifier);
        this.thisone.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                ValidatedTextField.this.setEditable(true);
                ValidatedTextField.this.setEnabled(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
                ValidatedTextField.this.exitFieldColorizer();
                ValidatedTextField.this.setEditable(true);
            }
        });
    }

    public ValidatedTextField(Integer len, int minAcceptableVal, int maxAcceptableVal, String validationErrorMessage) {
        super("0", len);
        this.fieldType = FieldType.LIMITEDHEX;
        this.validateRegExpr = null;
        this.validationErrorText = "ERROR:" + validationErrorMessage;
        this.minAllowedValue = minAcceptableVal;
        this.forceUpper = true;
        this.maxAllowedValue = maxAcceptableVal;
        this.allow0Length = false;
        this.verifier = new MyVerifier();
        this.setInvalidBackgroundColor(COLOR_BG_ERROR);
        this.thisone = this;
        this.thisone.setInputVerifier(this.verifier);
        this.thisone.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                ValidatedTextField.this.setEditable(true);
                ValidatedTextField.this.setEnabled(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
                ValidatedTextField.this.exitFieldColorizer();
                ValidatedTextField.this.setEditable(true);
            }
        });
    }

    private void exitFieldColorizer() {
        if (this.thisone.isEnabled()) {
            this.thisone.setForeground(COLOR_OK);
            this.thisone.firePropertyChange(VTF_PC_STAT_LN_UPDATE, "_", " ");
            if (this.getText() == null || this.getText().length() == 0) {
                if (this.allow0Length) {
                    if (this.lastQueryValue == null || this.lastQueryValue.length() == 0) {
                        this.setBackground(COLOR_BG_UNEDITED);
                    } else {
                        this.setBackground(COLOR_BG_EDITED);
                    }
                }
                return;
            }
            if (this.lastQueryValue == null || this.lastQueryValue.length() == 0) {
                this.setBackground(COLOR_BG_EDITED);
                return;
            }
            if (!this.lastQueryValue.equals(this.thisone.getText())) {
                this.thisone.setBackground(COLOR_BG_EDITED);
            } else {
                this.thisone.setBackground(COLOR_BG_UNEDITED);
            }
        }
    }

    @Override
    public boolean isValid() {
        if (this.thisone == null) {
            return false;
        }
        String value = this.getText();
        if (null == this.fieldType) {
            return false;
        }
        switch (this.fieldType) {
            case TEXT: {
                if (value.length() < 1 && !this.allow0Length) {
                    return false;
                }
                return this.allow0Length && value.length() == 0 || value.matches(this.validateRegExpr);
            }
            case INTEGRALNUMERIC: {
                try {
                    if (this.allow0Length && value.length() == 0) {
                        return true;
                    }
                    if (value.length() == 0) {
                        return false;
                    }
                    return Integer.parseInt(value) >= this.minAllowedValue && Integer.parseInt(value) <= this.maxAllowedValue;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            case INTEGRALNUMERICPLUSSTRING: {
                Integer findLocation = -1;
                if (this.allow0Length && value.length() == 0) {
                    return true;
                }
                if (value.length() == 0) {
                    return false;
                }
                Integer location = value.indexOf(99);
                if (location != -1 && location < findLocation) {
                    findLocation = location;
                }
                if ((location = Integer.valueOf(value.indexOf(67))) != -1 && location < findLocation) {
                    findLocation = location;
                }
                if ((location = Integer.valueOf(value.indexOf(116))) != -1 && location < findLocation) {
                    findLocation = location;
                }
                if ((location = Integer.valueOf(value.indexOf(84))) != -1 && location < findLocation) {
                    findLocation = location;
                }
                if (findLocation == -1) {
                    return false;
                }
                try {
                    int address = Integer.parseInt(value.substring(0, findLocation));
                    return address >= this.minAllowedValue && address <= this.maxAllowedValue && value.length() >= 2 && value.matches(this.validateRegExpr);
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            case LIMITEDHEX: {
                try {
                    if (value.isEmpty()) {
                        return false;
                    }
                    return Integer.parseInt(value, 16) >= this.minAllowedValue && Integer.parseInt(value, 16) <= this.maxAllowedValue;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        }
        return false;
    }

    public void setLastQueriedValue(String lastQueriedValue) {
        this.lastQueryValue = lastQueriedValue;
        this.exitFieldColorizer();
    }

    public String getLastQueriedValue() {
        return this.lastQueryValue;
    }

    public void setValidateRegExp(String validationRegExpr) {
        this.validateRegExpr = validationRegExpr;
    }

    public String getValidateRegExp() {
        return this.validateRegExpr;
    }

    public void setInvalidBackgroundColor(Color c) {
        this.invalidBackgroundColor = c;
    }

    static {
        COLOR_BG_UNEDITED = COLOR_BG_OK = Color.white;
        COLOR_BG_ERROR = Color.red;
    }

    private class MyVerifier
    extends InputVerifier
    implements ActionListener {
        private MyVerifier() {
        }

        @Override
        public boolean shouldYieldFocus(JComponent input, JComponent target) {
            if (input instanceof ValidatedTextField) {
                boolean inputOK;
                if (((ValidatedTextField)input).forceUpper) {
                    ((ValidatedTextField)input).setText(((ValidatedTextField)input).getText().toUpperCase());
                }
                if (inputOK = this.verify(input)) {
                    input.setForeground(COLOR_OK);
                    input.setBackground(COLOR_BG_OK);
                    return true;
                }
                input.setForeground(COLOR_ERROR_VAL);
                input.setBackground(ValidatedTextField.this.invalidBackgroundColor);
                ((JTextComponent)input).selectAll();
                ValidatedTextField.this.thisone.firePropertyChange(ValidatedTextField.VTF_PC_STAT_LN_UPDATE, " _ ", ValidatedTextField.this.validationErrorText);
                return false;
            }
            return false;
        }

        @Override
        public boolean verify(JComponent input) {
            if (input instanceof ValidatedTextField) {
                return input.isValid();
            }
            return false;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextField source = (JTextField)e.getSource();
            this.shouldYieldFocus(source, null);
            source.selectAll();
        }
    }

    private static enum FieldType {
        TEXT,
        INTEGRALNUMERIC,
        INTEGRALNUMERICPLUSSTRING,
        LIMITEDHEX;

    }
}

