/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.swing.mdi;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JDesktopPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import jmri.util.JmriJFrame;
import jmri.util.swing.JMenuUtil;
import jmri.util.swing.JToolBarUtil;
import jmri.util.swing.JTreeUtil;
import jmri.util.swing.mdi.JmriJInternalFrameInterface;

public class MdiMainFrame
extends JmriJFrame {
    JSplitPane leftRightSplitPane;
    JDesktopPane desktop;
    JmriJInternalFrameInterface rightWI;

    public MdiMainFrame(String name, String treeFile, String menubarFile, String toolbarFile) {
        super(name);
        this.configureFrame(treeFile);
        this.addMainMenuBar(menubarFile);
        this.addMainToolBar(toolbarFile);
        this.pack();
    }

    protected void configureFrame(String treeFile) {
        this.desktop = new JDesktopPane();
        this.desktop.setBorder(BorderFactory.createLineBorder(Color.black));
        this.leftRightSplitPane = new JSplitPane(1, this.makeLeftTree(treeFile), this.desktop);
        this.leftRightSplitPane.setOneTouchExpandable(true);
        this.leftRightSplitPane.setResizeWeight(0.0);
        this.add((Component)this.leftRightSplitPane, "Center");
    }

    protected JScrollPane makeLeftTree(String treeFile) {
        this.rightWI = new JmriJInternalFrameInterface(this, this.desktop);
        DefaultMutableTreeNode topNode = JTreeUtil.loadTree(treeFile, this.rightWI, null);
        JTree tree = new JTree(topNode);
        tree.getSelectionModel().setSelectionMode(1);
        tree.setRootVisible(false);
        tree.addTreeSelectionListener(e -> {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            if (node.getUserObject() == null) {
                return;
            }
            if (node.getUserObject() instanceof AbstractAction) {
                AbstractAction action = (AbstractAction)node.getUserObject();
                action.actionPerformed(null);
            }
        });
        JScrollPane treeView = new JScrollPane(tree);
        treeView.setMinimumSize(new Dimension(0, 0));
        treeView.setPreferredSize(new Dimension(150, 600));
        return treeView;
    }

    protected void addMainMenuBar(String menuFile) {
        JMenu[] menus;
        JMenuBar menuBar = new JMenuBar();
        for (JMenu j : menus = JMenuUtil.loadMenu(menuFile, this.rightWI, null)) {
            menuBar.add(j);
        }
        this.setJMenuBar(menuBar);
    }

    protected void addMainToolBar(String toolBarFile) {
        JToolBar toolBar = JToolBarUtil.loadToolBar(toolBarFile, this.rightWI, null);
        this.add((Component)toolBar, "North");
    }

    @Override
    public void dispose() {
        this.rightWI.dispose();
        super.dispose();
    }
}

