/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.swing.multipane;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import jmri.util.JmriJFrame;
import jmri.util.swing.JMenuUtil;
import jmri.util.swing.JToolBarUtil;
import jmri.util.swing.JTreeUtil;
import jmri.util.swing.multipane.PanedInterface;

public class MultiPaneWindow
extends JmriJFrame {
    JSplitPane leftRightSplitPane;
    JPanel left = new JPanel();
    JSplitPane rightUpDownSplitPane;
    JPanel rightTop = new JPanel();
    JPanel rightBottom = new JPanel();
    PanedInterface rightTopWI;

    public MultiPaneWindow(String name, String treeFile, String menubarFile, String toolbarFile) {
        super(name);
        this.buildGUI(treeFile, menubarFile, toolbarFile);
        this.pack();
    }

    public JComponent getLowerRight() {
        return this.rightBottom;
    }

    public JComponent getUpperRight() {
        return this.rightTop;
    }

    protected void buildGUI(String treeFile, String menubarFile, String toolbarFile) {
        this.configureFrame();
        this.configureNavTreePane(treeFile);
        this.addMainMenuBar(menubarFile);
        this.addMainToolBar(toolbarFile);
    }

    protected void configureFrame() {
        this.rightTop.setBorder(BorderFactory.createLineBorder(Color.black));
        this.rightTop.setLayout(new FlowLayout());
        this.rightBottom.setLayout(new FlowLayout());
        this.rightUpDownSplitPane = new JSplitPane(0, this.rightTop, this.rightBottom);
        this.rightUpDownSplitPane.setOneTouchExpandable(true);
        this.rightUpDownSplitPane.setResizeWeight(1.0);
        this.leftRightSplitPane = new JSplitPane(1, new JPanel(), this.rightUpDownSplitPane);
        this.leftRightSplitPane.setOneTouchExpandable(true);
        this.leftRightSplitPane.setResizeWeight(0.0);
        this.add((Component)this.leftRightSplitPane, "Center");
    }

    protected void configureNavTreePane(String treeFile) {
        this.leftRightSplitPane.setLeftComponent(this.makeNavTreePane(treeFile));
    }

    protected JScrollPane makeNavTreePane(String treeFile) {
        this.rightTopWI = new PanedInterface(this);
        TreeNode topNode = this.makeNavTreeTopNode(treeFile, this.rightTopWI);
        final JTree tree = new JTree(topNode);
        tree.getSelectionModel().setSelectionMode(1);
        tree.setRootVisible(false);
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                if (node.getUserObject() == null) {
                    return;
                }
                if (node.getUserObject() instanceof AbstractAction) {
                    AbstractAction action = (AbstractAction)node.getUserObject();
                    action.actionPerformed(null);
                }
            }
        });
        JScrollPane treeView = new JScrollPane(tree);
        treeView.setMinimumSize(new Dimension(0, 0));
        treeView.setPreferredSize(new Dimension(150, 600));
        return treeView;
    }

    protected TreeNode makeNavTreeTopNode(String treeFile, PanedInterface rightTopWI) {
        return JTreeUtil.loadTree(treeFile, rightTopWI, null);
    }

    public void resetRightToPreferredSizes() {
        this.rightUpDownSplitPane.resetToPreferredSizes();
    }

    protected void addMainMenuBar(String menuFile) {
        JMenu[] menus;
        JMenuBar menuBar = new JMenuBar();
        for (JMenu j : menus = JMenuUtil.loadMenu(menuFile, this.rightTopWI, null)) {
            menuBar.add(j);
        }
        this.setJMenuBar(menuBar);
    }

    protected void addMainToolBar(String toolBarFile) {
        JToolBar toolBar = JToolBarUtil.loadToolBar(toolBarFile, this.rightTopWI, null);
        this.add((Component)toolBar, "North");
    }

    @Override
    public void dispose() {
        this.rightTopWI.dispose();
        super.dispose();
    }
}

