/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.swing.multipane;

import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import jmri.util.JmriJFrame;
import jmri.util.swing.JMenuUtil;
import jmri.util.swing.JToolBarUtil;
import jmri.util.swing.WindowInterface;
import jmri.util.swing.sdi.JmriJFrameInterface;

public class ThreePaneTLRWindow
extends JmriJFrame {
    JSplitPane upDownSplitPane;
    JSplitPane leftRightSplitPane;
    JPanel top = new JPanel();
    JPanel left = new JPanel();
    JPanel right = new JPanel();
    WindowInterface rightTopWI;

    public ThreePaneTLRWindow(String name, String menubarFile, String toolbarFile) {
        super(name);
        this.buildGUI(menubarFile, toolbarFile);
        this.pack();
    }

    public JComponent getTop() {
        return this.top;
    }

    public JComponent getRight() {
        return this.right;
    }

    public JComponent getLeft() {
        return this.left;
    }

    protected void buildGUI(String menubarFile, String toolbarFile) {
        this.configureFrame();
        this.addMainMenuBar(menubarFile);
        this.addMainToolBar(toolbarFile);
    }

    protected void configureFrame() {
        this.rightTopWI = new JmriJFrameInterface();
        this.top.setLayout(new BoxLayout(this.top, 0));
        this.right.setLayout(new FlowLayout());
        this.left.setLayout(new FlowLayout());
        this.leftRightSplitPane = new JSplitPane(1, this.left, this.right);
        this.leftRightSplitPane.setOneTouchExpandable(true);
        this.leftRightSplitPane.setResizeWeight(0.0);
        this.upDownSplitPane = new JSplitPane(0, this.top, this.leftRightSplitPane);
        this.upDownSplitPane.setOneTouchExpandable(true);
        this.upDownSplitPane.setResizeWeight(1.0);
        this.add((Component)this.upDownSplitPane, "Center");
    }

    public void resetRightToPreferredSizes() {
        this.leftRightSplitPane.resetToPreferredSizes();
    }

    protected void addMainMenuBar(String menuFile) {
        JMenu[] menus;
        if (menuFile == null) {
            return;
        }
        JMenuBar menuBar = new JMenuBar();
        for (JMenu j : menus = JMenuUtil.loadMenu(menuFile, this.rightTopWI, null)) {
            menuBar.add(j);
        }
        this.setJMenuBar(menuBar);
    }

    protected void addMainToolBar(String toolBarFile) {
        if (toolBarFile == null) {
            return;
        }
        JToolBar toolBar = JToolBarUtil.loadToolBar(toolBarFile, this.rightTopWI, null);
        this.add((Component)toolBar, "North");
    }

    @Override
    public void dispose() {
        this.rightTopWI.dispose();
        super.dispose();
    }
}

