/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.swing.multipane;

import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.border.BevelBorder;
import jmri.InstanceManager;
import jmri.util.JmriJFrame;
import jmri.util.gui.GuiLafPreferencesManager;
import jmri.util.swing.JMenuUtil;
import jmri.util.swing.JToolBarUtil;

public abstract class TwoPaneTBWindow
extends JmriJFrame {
    JSplitPane upDownSplitPane;
    JPanel top = new JPanel();
    JPanel bottom = new JPanel();
    JPanel statusBar = new JPanel();
    JToolBar toolBar = new JToolBar();
    protected boolean hideBottomPane = false;
    JMenuBar menuBar = new JMenuBar();
    Box statusBox;
    int statusBoxIndex = 0;
    static final int statusStrutWidth = 10;

    public TwoPaneTBWindow(String name, String menubarFile, String toolbarFile) {
        super(name);
        this.buildGUI(menubarFile, toolbarFile);
        this.pack();
    }

    public JComponent getTop() {
        return this.top;
    }

    public JComponent getBottom() {
        return this.bottom;
    }

    public JComponent getToolBar() {
        return this.toolBar;
    }

    public JComponent getSplitPane() {
        return this.upDownSplitPane;
    }

    protected void buildGUI(String menubarFile, String toolbarFile) {
        this.configureFrame();
        this.addMainMenuBar(menubarFile);
        this.addMainToolBar(toolbarFile);
        this.addMainStatusBar();
    }

    protected void configureFrame() {
        this.top.setLayout(new BoxLayout(this.top, 0));
        this.bottom.setLayout(new BoxLayout(this.bottom, 0));
        this.upDownSplitPane = new JSplitPane(0, this.top, this.bottom);
        this.upDownSplitPane.setOneTouchExpandable(true);
        this.upDownSplitPane.setResizeWeight(1.0);
        this.add((Component)this.upDownSplitPane, "Center");
    }

    public void resetTopToPreferredSizes() {
        this.upDownSplitPane.resetToPreferredSizes();
    }

    public void hideBottomPane(boolean hide) {
        if (this.hideBottomPane == hide) {
            return;
        }
        this.hideBottomPane = hide;
        if (hide) {
            this.upDownSplitPane.setDividerLocation(1.0);
        } else {
            this.resetTopToPreferredSizes();
        }
    }

    protected void addMainMenuBar(String menuFile) {
        JMenu[] menus;
        if (menuFile == null) {
            return;
        }
        for (JMenu j : menus = JMenuUtil.loadMenu(menuFile, this, this)) {
            this.menuBar.add(j);
        }
        this.setJMenuBar(this.menuBar);
    }

    public JMenuBar getMenu() {
        return this.menuBar;
    }

    protected void addMainToolBar(String toolBarFile) {
        if (toolBarFile == null) {
            return;
        }
        this.toolBar = JToolBarUtil.loadToolBar(toolBarFile, this, this);
        this.add((Component)this.toolBar, "North");
    }

    public abstract void remoteCalls(String[] var1);

    protected void addMainStatusBar() {
        this.statusBar.setLayout(new FlowLayout(0, 2, 0));
        this.statusBar.setBorder(new BevelBorder(1));
        this.statusBox = Box.createHorizontalBox();
        this.statusBox.add(Box.createHorizontalGlue());
        this.statusBar.add(this.statusBox);
        this.add((Component)this.statusBar, "South");
    }

    public void addToStatusBox(JLabel title, JLabel value) {
        JPanel statusItemPanel = new JPanel();
        statusItemPanel.setLayout(new FlowLayout(1, 5, 0));
        int fontSize = InstanceManager.getDefault(GuiLafPreferencesManager.class).getFontSize() - 1;
        if (title != null) {
            if (fontSize <= 4) {
                fontSize = title.getFont().getSize() - 1;
            }
            title.setFont(title.getFont().deriveFont(0, fontSize));
            statusItemPanel.add(title);
        }
        if (value != null) {
            if (fontSize <= 4) {
                fontSize = value.getFont().getSize() - 1;
            }
            value.setFont(value.getFont().deriveFont(0, fontSize));
            statusItemPanel.add(value);
        }
        this.addToStatusBox(statusItemPanel);
    }

    public void addToStatusBox(Component comp) {
        if (this.statusBoxIndex != 0) {
            this.statusBox.add(Box.createHorizontalStrut(10), this.statusBoxIndex);
            ++this.statusBoxIndex;
            this.statusBox.add((Component)new JSeparator(1), this.statusBoxIndex);
            ++this.statusBoxIndex;
        }
        this.statusBox.add(comp, this.statusBoxIndex);
        ++this.statusBoxIndex;
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}

