/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import jmri.util.swing.JmriMouseEvent;
import jmri.util.swing.JmriMouseListener;
import jmri.util.table.BasicCellEditor;

public class ButtonEditor
extends BasicCellEditor
implements ActionListener,
TableCellEditor,
JmriMouseListener {
    protected Object value;
    protected Color foreground;
    protected Color background;
    protected Font font;

    public ButtonEditor(JButton button) {
        super(button);
        button.addActionListener(this);
        button.addMouseListener(JmriMouseListener.adapt(this));
        button.putClientProperty("JComponent.sizeVariant", "small");
        button.putClientProperty("JButton.buttonType", "square");
    }

    public void setForeground(Color foreground) {
        this.foreground = foreground;
        this.editor.setForeground(foreground);
    }

    public void setBackground(Color background) {
        this.background = background;
        this.editor.setBackground(background);
    }

    public void setFont(Font font) {
        this.font = font;
        this.editor.setFont(font);
    }

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    @Override
    public void editingStarted(EventObject event) {
        if (!(event instanceof MouseEvent)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((JButton)ButtonEditor.this.editor).doClick();
                }
            });
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable tbl, Object value, boolean isSelected, int row, int column) {
        this.editor.setForeground(this.foreground != null ? this.foreground : tbl.getForeground());
        this.editor.setBackground(this.background != null ? this.background : tbl.getBackground());
        this.editor.setFont(this.font != null ? this.font : tbl.getFont());
        this.value = value;
        this.setValue(value);
        return this.editor;
    }

    protected void setValue(Object value) {
        JButton button = (JButton)this.editor;
        if (value == null) {
            button.setText("");
            button.setIcon(null);
            button.setEnabled(false);
        } else if (value instanceof Icon) {
            button.setText("");
            button.setIcon((Icon)value);
            button.setEnabled(true);
        } else {
            button.setText(value.toString());
            button.setIcon(null);
            button.setEnabled(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.stopCellEditing();
    }

    @Override
    public void mousePressed(JmriMouseEvent e) {
    }

    @Override
    public void mouseExited(JmriMouseEvent e) {
    }

    @Override
    public void mouseEntered(JmriMouseEvent e) {
    }

    @Override
    public void mouseReleased(JmriMouseEvent e) {
    }

    @Override
    public void mouseClicked(JmriMouseEvent e) {
    }
}

