/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public class ButtonRenderer
extends JButton
implements TableCellRenderer {
    protected Color foreground;
    protected Color background;
    protected Font font;
    protected Border border = this.getBorder();

    public ButtonRenderer() {
        this.setOpaque(true);
        this.putClientProperty("JComponent.sizeVariant", "small");
        this.putClientProperty("JButton.buttonType", "square");
    }

    @Override
    public void setForeground(Color foreground) {
        this.foreground = foreground;
        super.setForeground(foreground);
    }

    @Override
    public void setBackground(Color background) {
        this.background = background;
        super.setBackground(background);
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
        super.setFont(font);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color cellForeground = this.foreground != null ? this.foreground : table.getForeground();
        Color cellBackground = this.background != null ? this.background : table.getBackground();
        this.setFont(this.font != null ? this.font : table.getFont());
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (table.isCellEditable(row, column)) {
                cellForeground = UIManager.getColor("Table.focusCellForeground");
                cellBackground = UIManager.getColor("Table.focusCellBackground");
            }
        } else {
            this.setBorder(this.border);
        }
        super.setForeground(cellForeground);
        super.setBackground(cellBackground);
        this.setValue(value);
        return this;
    }

    protected void setValue(Object value) {
        if (value == null) {
            this.setText("");
            this.setIcon(null);
            this.setEnabled(false);
        } else if (value instanceof Icon) {
            this.setText("");
            this.setIcon((Icon)value);
            this.setEnabled(true);
        } else {
            this.setText(value.toString());
            this.setIcon(null);
            this.setEnabled(true);
        }
    }
}

