/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.table;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import jmri.Manager;
import jmri.NamedBean;
import jmri.swing.NamedBeanComboBox;
import jmri.util.SystemType;

public class NamedBeanBoxRenderer<T extends NamedBean>
extends NamedBeanComboBox<T>
implements TableCellRenderer {
    private final Border normalBorder;
    private final Border errorBorder = BorderFactory.createLineBorder(Color.RED);

    public NamedBeanBoxRenderer(Manager<T> mgr) {
        super(mgr);
        this.normalBorder = this.getBorder();
        this.setAllowNull(true);
    }

    public void setNormalBorder() {
        this.setBorder(this.normalBorder);
    }

    public void setErrorBorder() {
        this.setBorder(this.errorBorder);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (!SystemType.isMacOSX() || !UIManager.getLookAndFeel().isNativeLookAndFeel()) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
        }
        this.setSelectedItem(value instanceof NamedBean ? (NamedBean)value : null);
        return this;
    }
}

