/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.usb;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.usb.UsbConfiguration;
import javax.usb.UsbDevice;
import javax.usb.UsbDeviceDescriptor;
import javax.usb.UsbDisconnectedException;
import javax.usb.UsbException;
import javax.usb.UsbHostManager;
import javax.usb.UsbHub;
import javax.usb.UsbInterface;
import javax.usb.UsbNotActiveException;
import javax.usb.UsbNotClaimedException;
import javax.usb.UsbNotOpenException;
import javax.usb.UsbPipe;
import javax.usb.UsbPort;
import javax.usb.event.UsbPipeDataEvent;
import javax.usb.event.UsbPipeErrorEvent;
import javax.usb.event.UsbPipeListener;
import jmri.util.usb.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UsbUtil {
    private static final Logger log = LoggerFactory.getLogger(UsbUtil.class);

    private UsbUtil() {
    }

    public static List<UsbDevice> getAllDevices() {
        return UsbUtil.getMatchingDevices((short)0, (short)0, null);
    }

    public static List<UsbDevice> getMatchingDevices(short idVendor, short idProduct, @CheckForNull String serialNumber) {
        return UsbUtil.findUsbDevices(null, idVendor, idProduct, serialNumber);
    }

    @CheckForNull
    public static UsbDevice getMatchingDevice(short idVendor, short idProduct, @CheckForNull String serialNumber, @Nonnull String idLocation) {
        for (UsbDevice usbDevice : UsbUtil.findUsbDevices(null, idVendor, idProduct, serialNumber)) {
            String locationID = UsbUtil.getLocation(usbDevice);
            if (!locationID.equals(idLocation)) continue;
            return usbDevice;
        }
        return null;
    }

    @CheckForNull
    public static String getFullProductName(@Nonnull UsbDevice usbDevice) {
        String result = null;
        try {
            String manufacturer = usbDevice.getManufacturerString();
            String product = usbDevice.getProductString();
            if (product != null) {
                result = manufacturer == null || product.startsWith(manufacturer) ? product : Bundle.getMessage("UsbDevice", manufacturer, product);
            }
        }
        catch (UnsupportedEncodingException | UsbException ex) {
            log.error("Unable to read data from {}", (Object)usbDevice, (Object)ex);
        }
        catch (UsbDisconnectedException ex) {
            log.error("Unable to read data from disconnected device {}", (Object)usbDevice);
        }
        return result;
    }

    @CheckForNull
    public static String getSerialNumber(@Nonnull UsbDevice usbDevice) {
        try {
            return usbDevice.getSerialNumberString();
        }
        catch (UnsupportedEncodingException | UsbDisconnectedException | UsbException ex) {
            log.error("Unable to get serial number of {}", (Object)usbDevice);
            return null;
        }
    }

    public static String getLocation(@Nonnull UsbDevice usbDevice) {
        UsbPort port;
        UsbDevice device = usbDevice;
        StringBuilder path = new StringBuilder();
        while (device != null && (port = device.getParentUsbPort()) != null) {
            path.append(Byte.toString(port.getPortNumber())).append(':');
            device = port.getUsbHub();
        }
        return String.format("USB%s", path.reverse().toString());
    }

    @Nonnull
    private static List<UsbDevice> findUsbDevices(@CheckForNull UsbHub usbHub, short idVendor, short idProduct, @CheckForNull String serialNumber) {
        if (usbHub == null) {
            try {
                return UsbUtil.findUsbDevices(UsbHostManager.getUsbServices().getRootUsbHub(), idVendor, idProduct, serialNumber);
            }
            catch (SecurityException | UsbException ex) {
                log.error("Exception: {}", (Object)ex.toString());
                return new ArrayList<UsbDevice>();
            }
        }
        List usbDevices = usbHub.getAttachedUsbDevices();
        ArrayList<UsbDevice> devices = new ArrayList<UsbDevice>();
        usbDevices.forEach(usbDevice -> {
            if (usbDevice instanceof UsbHub) {
                UsbHub childUsbHub = (UsbHub)usbDevice;
                devices.addAll(UsbUtil.findUsbDevices(childUsbHub, idVendor, idProduct, serialNumber));
            } else {
                UsbDeviceDescriptor usbDeviceDescriptor = usbDevice.getUsbDeviceDescriptor();
                try {
                    if (!(idVendor != 0 && idVendor != usbDeviceDescriptor.idVendor() || idProduct != 0 && idProduct != usbDeviceDescriptor.idProduct() || serialNumber != null && !serialNumber.equals(usbDevice.getSerialNumberString()))) {
                        devices.add((UsbDevice)usbDevice);
                    }
                }
                catch (UnsupportedEncodingException | UsbDisconnectedException | UsbException ex) {
                    log.error("Unable to request serial number from device {}", usbDevice, (Object)ex);
                }
            }
        });
        return devices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readMessage(@Nonnull UsbInterface iface, byte endPoint) {
        try {
            iface.claim(usbInterface -> true);
            UsbPipe pipe = iface.getUsbEndpoint(endPoint).getUsbPipe();
            pipe.open();
            byte[] data = new byte[8];
            int received = pipe.syncSubmit(data);
            log.debug("{} bytes received", (Object)received);
            pipe.close();
        }
        catch (IllegalArgumentException | UsbDisconnectedException | UsbException | UsbNotActiveException | UsbNotClaimedException | UsbNotOpenException ex) {
            log.error("Unable to read message", ex);
        }
        finally {
            try {
                iface.release();
            }
            catch (UsbDisconnectedException | UsbException | UsbNotActiveException ex) {
                log.error("Unable to release USB device", ex);
            }
        }
    }

    public static void readMessageAsynch(@Nonnull UsbInterface iface, byte endPoint) {
        try {
            iface.claim(usbInterface -> true);
            UsbPipe pipe = iface.getUsbEndpoint(endPoint).getUsbPipe();
            pipe.open();
            pipe.addUsbPipeListener(new UsbPipeListener(){

                public void errorEventOccurred(UsbPipeErrorEvent event) {
                    log.error("UsbPipeErrorEvent: {}", (Object)event, (Object)event.getUsbException());
                }

                public void dataEventOccurred(UsbPipeDataEvent event) {
                    byte[] data = event.getData();
                    if (log.isDebugEnabled()) {
                        log.debug("bytes received: {}", (Object)Arrays.toString(data));
                    }
                }
            });
            pipe.close();
        }
        catch (UsbDisconnectedException | UsbException | UsbNotActiveException | UsbNotClaimedException | UsbNotOpenException ex) {
            log.error("Unable to read USB message.", ex);
        }
        finally {
            try {
                iface.release();
            }
            catch (UsbDisconnectedException | UsbException | UsbNotActiveException ex) {
                log.error("Unable to release USB device.", ex);
            }
        }
    }

    public static UsbInterface getDeviceInterface(@Nonnull UsbDevice device, byte index) {
        UsbConfiguration configuration = device.getActiveUsbConfiguration();
        if (configuration != null) {
            return configuration.getUsbInterface(index);
        }
        return null;
    }
}

