/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.zeroconf;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jmdns.ServiceInfo;
import jmri.InstanceManager;
import jmri.util.zeroconf.ZeroConfServiceListener;
import jmri.util.zeroconf.ZeroConfServiceManager;

public class ZeroConfService {
    private final HashMap<InetAddress, ServiceInfo> serviceInfos = new HashMap();
    private ServiceInfo serviceInfo = null;
    private final List<ZeroConfServiceListener> listeners = new ArrayList<ZeroConfServiceListener>();
    public static final String IPv4 = "IPv4";
    public static final String IPv6 = "IPv6";
    public static final String LOOPBACK = "loopback";
    public static final String LINKLOCAL = "linklocal";

    public static ZeroConfService create(String type, int port) {
        return InstanceManager.getDefault(ZeroConfServiceManager.class).create(type, port);
    }

    public static ZeroConfService create(String type, int port, HashMap<String, String> properties) {
        return InstanceManager.getDefault(ZeroConfServiceManager.class).create(type, port, properties);
    }

    public static ZeroConfService create(String type, String name, int port, int weight, int priority, HashMap<String, String> properties) {
        return InstanceManager.getDefault(ZeroConfServiceManager.class).create(type, name, port, weight, priority, properties);
    }

    protected ZeroConfService(ServiceInfo service) {
        this.serviceInfo = service;
    }

    public String getKey() {
        return this.getServiceInfo().getKey();
    }

    public String getName() {
        return this.getServiceInfo().getName();
    }

    public String getType() {
        return this.getServiceInfo().getType();
    }

    ServiceInfo getServiceInfo(InetAddress address) {
        return this.serviceInfos.get(address);
    }

    ServiceInfo addServiceInfo(InetAddress address) {
        if (!this.serviceInfos.containsKey(address)) {
            this.serviceInfos.put(address, this.getServiceInfo().clone());
        }
        return this.serviceInfos.get(address);
    }

    void removeServiceInfo(InetAddress address) {
        this.serviceInfos.remove(address);
    }

    boolean containsServiceInfo(InetAddress key) {
        return this.serviceInfos.containsKey(key);
    }

    public ServiceInfo getServiceInfo() {
        return this.serviceInfo;
    }

    public boolean isPublished() {
        return InstanceManager.getDefault(ZeroConfServiceManager.class).isPublished(this);
    }

    public void publish() {
        InstanceManager.getDefault(ZeroConfServiceManager.class).publish(this);
    }

    public void stop() {
        InstanceManager.getDefault(ZeroConfServiceManager.class).stop(this);
    }

    public void addEventListener(ZeroConfServiceListener l) {
        this.listeners.add(l);
    }

    public void removeEventListener(ZeroConfServiceListener l) {
        this.listeners.remove(l);
    }

    public List<ZeroConfServiceListener> getListeners() {
        return new ArrayList<ZeroConfServiceListener>(this.listeners);
    }
}

