/*
 * Decompiled with CFR 0.152.
 */
package jmri.web.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import jmri.InstanceManagerAutoDefault;
import jmri.beans.PreferencesBean;
import jmri.profile.ProfileManager;
import jmri.profile.ProfileUtils;
import jmri.web.server.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServerPreferences
extends PreferencesBean
implements InstanceManagerAutoDefault {
    public static final String DISALLOWED_FRAMES = "disallowedFrames";
    public static final String WEB_SERVER_PREFERENCES = "WebServerPreferences";
    public static final String FRAME = "frame";
    public static final String PORT = "port";
    public static final String CLICK_DELAY = "clickDelay";
    public static final String REFRESH_DELAY = "refreshDelay";
    public static final String USE_AJAX = "useAjax";
    public static final String SIMPLE = "simple";
    public static final String RAILROAD_NAME = "railroadName";
    public static final String ALLOW_REMOTE_CONFIG = "allowRemoteConfig";
    public static final String READONLY_POWER = "readonlyPower";
    public static final String DISABLE_FRAME_SERVER = "disableFrames";
    public static final String REDIRECT_FRAMES = "redirectFramesToPanels";
    public static final String USE_ZERO_CONF = "useZeroConf";
    private static final String DEFAULT_RAILROAD_NAME = "DefaultRailroadName";
    private int clickDelay = 1;
    private int refreshDelay = 5;
    private boolean useAjax = true;
    private boolean simple = false;
    private final ArrayList<String> disallowedFrames = new ArrayList<String>(Arrays.asList(Bundle.getMessage("DefaultDisallowedFrames").split(";")));
    private String railroadName = Bundle.getMessage("DefaultRailroadName");
    private boolean allowRemoteConfig = false;
    private boolean readonlyPower = true;
    private int port = 12080;
    private boolean disableFrames = true;
    private boolean redirectFramesToPanels = true;
    private static final Logger log = LoggerFactory.getLogger(WebServerPreferences.class);
    private boolean useZeroConf = true;

    public WebServerPreferences() {
        super(ProfileManager.getDefault().getActiveProfile());
        Preferences sharedPreferences = ProfileUtils.getPreferences(super.getProfile(), this.getClass(), true);
        this.readPreferences(sharedPreferences);
    }

    private void readPreferences(Preferences sharedPreferences) {
        this.allowRemoteConfig = sharedPreferences.getBoolean(ALLOW_REMOTE_CONFIG, this.allowRemoteConfig);
        this.clickDelay = sharedPreferences.getInt(CLICK_DELAY, this.clickDelay);
        this.simple = sharedPreferences.getBoolean(SIMPLE, this.simple);
        this.railroadName = sharedPreferences.get(RAILROAD_NAME, this.railroadName);
        this.readonlyPower = sharedPreferences.getBoolean(READONLY_POWER, this.readonlyPower);
        this.refreshDelay = sharedPreferences.getInt(REFRESH_DELAY, this.refreshDelay);
        this.useAjax = sharedPreferences.getBoolean(USE_AJAX, this.useAjax);
        this.disableFrames = sharedPreferences.getBoolean(DISABLE_FRAME_SERVER, this.disableFrames);
        this.redirectFramesToPanels = sharedPreferences.getBoolean(REDIRECT_FRAMES, this.redirectFramesToPanels);
        try {
            Preferences frames = sharedPreferences.node(DISALLOWED_FRAMES);
            if (frames.keys().length != 0) {
                this.disallowedFrames.clear();
                for (String key : frames.keys()) {
                    String frame = frames.get(key, null);
                    if (frame == null || frame.trim().isEmpty()) continue;
                    this.disallowedFrames.add(frame);
                }
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        this.port = sharedPreferences.getInt(PORT, this.port);
        this.useZeroConf = sharedPreferences.getBoolean(USE_ZERO_CONF, this.useZeroConf);
        this.setIsDirty(false);
    }

    public void save() {
        Preferences sharedPreferences = ProfileUtils.getPreferences(this.getProfile(), this.getClass(), true);
        sharedPreferences.putInt(PORT, this.getPort());
        sharedPreferences.putBoolean(USE_ZERO_CONF, this.isUseZeroConf());
        sharedPreferences.putInt(CLICK_DELAY, this.getClickDelay());
        sharedPreferences.putInt(REFRESH_DELAY, this.getRefreshDelay());
        sharedPreferences.putBoolean(USE_AJAX, this.isUseAjax());
        sharedPreferences.putBoolean(SIMPLE, this.isSimple());
        sharedPreferences.putBoolean(ALLOW_REMOTE_CONFIG, this.allowRemoteConfig());
        sharedPreferences.putBoolean(READONLY_POWER, this.isReadonlyPower());
        sharedPreferences.put(RAILROAD_NAME, this.getRailroadName());
        sharedPreferences.putBoolean(DISABLE_FRAME_SERVER, this.isDisableFrames());
        sharedPreferences.putBoolean(REDIRECT_FRAMES, this.redirectFramesToPanels);
        try {
            Preferences node = sharedPreferences.node(DISALLOWED_FRAMES);
            this.disallowedFrames.stream().forEach(frame -> node.put(Integer.toString(this.disallowedFrames.indexOf(frame)), (String)frame));
            if (this.disallowedFrames.size() < node.keys().length) {
                for (int i = node.keys().length - 1; i >= this.disallowedFrames.size(); --i) {
                    node.remove(Integer.toString(i));
                }
            }
            sharedPreferences.sync();
            this.setIsDirty(false);
        }
        catch (BackingStoreException ex) {
            log.error("Exception while saving web server preferences", (Throwable)ex);
        }
    }

    public int getClickDelay() {
        return this.clickDelay;
    }

    public void setClickDelay(int value) {
        int old = this.clickDelay;
        if (old != value) {
            this.clickDelay = value;
            this.firePropertyChange(CLICK_DELAY, old, value);
        }
    }

    public int getRefreshDelay() {
        return this.refreshDelay;
    }

    public void setRefreshDelay(int value) {
        int old = this.refreshDelay;
        if (old != value) {
            this.refreshDelay = value;
            this.firePropertyChange(REFRESH_DELAY, old, value);
        }
    }

    public String[] getDisallowedFrames() {
        return this.disallowedFrames.toArray(new String[this.disallowedFrames.size()]);
    }

    public boolean isUseAjax() {
        return this.useAjax;
    }

    public void setUseAjax(boolean useAjax) {
        boolean old = this.useAjax;
        if (old != useAjax) {
            this.useAjax = useAjax;
            this.firePropertyChange(USE_AJAX, old, useAjax);
        }
    }

    public boolean isSimple() {
        return this.simple;
    }

    public void setSimple(boolean value) {
        boolean old = this.simple;
        if (old != value) {
            this.simple = value;
            this.firePropertyChange(SIMPLE, old, value);
        }
    }

    public boolean isUseZeroConf() {
        return this.useZeroConf;
    }

    public void setUseZeroConf(boolean value) {
        boolean old = this.useZeroConf;
        if (old != value) {
            this.useZeroConf = value;
            this.firePropertyChange(USE_ZERO_CONF, old, value);
        }
    }

    public boolean allowRemoteConfig() {
        return this.allowRemoteConfig;
    }

    public void setAllowRemoteConfig(boolean value) {
        boolean old = this.allowRemoteConfig;
        if (old != value) {
            this.allowRemoteConfig = value;
            this.firePropertyChange(ALLOW_REMOTE_CONFIG, old, value);
        }
    }

    public boolean isReadonlyPower() {
        return this.readonlyPower;
    }

    public void setReadonlyPower(boolean readonlyPower) {
        this.readonlyPower = readonlyPower;
    }

    public void setDisallowedFrames(String[] disallowedFrames) {
        Object[] old = this.getDisallowedFrames();
        if (!Arrays.equals(old, disallowedFrames)) {
            this.disallowedFrames.clear();
            this.disallowedFrames.addAll(Arrays.asList(disallowedFrames));
            this.firePropertyChange(DISALLOWED_FRAMES, old, disallowedFrames);
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int value) {
        int old = this.port;
        if (old != value) {
            this.port = value;
            this.firePropertyChange(PORT, old, value);
            this.setRestartRequired();
        }
    }

    public String getRailroadName() {
        return this.railroadName;
    }

    public void setRailroadName(String railroadName) {
        String old = this.railroadName;
        if (old != null && !old.equals(railroadName) || railroadName != null) {
            this.railroadName = railroadName != null ? railroadName : Bundle.getMessage(DEFAULT_RAILROAD_NAME);
            this.firePropertyChange(RAILROAD_NAME, old, this.railroadName);
        }
    }

    public boolean isDefaultRailroadName() {
        return this.getRailroadName().equals(Bundle.getMessage(DEFAULT_RAILROAD_NAME));
    }

    public String getDefaultRailroadName() {
        return Bundle.getMessage(DEFAULT_RAILROAD_NAME);
    }

    public boolean isDisableFrames() {
        return this.disableFrames;
    }

    public void setDisableFrames(boolean disableFrames) {
        boolean old = this.disableFrames;
        if (old != disableFrames) {
            this.disableFrames = disableFrames;
            this.firePropertyChange(DISABLE_FRAME_SERVER, old, disableFrames);
        }
    }

    public boolean isRedirectFramesToPanels() {
        return this.redirectFramesToPanels;
    }

    public void setRedirectFramesToPanels(boolean redirectFramesToPanels) {
        boolean old = this.redirectFramesToPanels;
        if (old != redirectFramesToPanels) {
            this.redirectFramesToPanels = redirectFramesToPanels;
            this.firePropertyChange(REDIRECT_FRAMES, old, this.redirectFramesToPanels);
        }
    }
}

