/*
 * Decompiled with CFR 0.152.
 */
package jmri.web.servlet.directory;

import java.io.IOException;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import jmri.InstanceManager;
import jmri.util.FileUtil;
import jmri.web.servlet.ServletUtil;
import jmri.web.servlet.directory.Bundle;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryResource
extends PathResource {
    private final Locale locale;
    private static final Logger log = LoggerFactory.getLogger(DirectoryResource.class);

    public DirectoryResource(Locale locale, Resource resource) throws IOException {
        super(resource.getFile());
        this.locale = locale;
    }

    public String getListHTML(String base, boolean parent, String query) throws IOException {
        String basePath = URIUtil.canonicalPath((String)base);
        if (basePath == null || !this.isDirectory()) {
            return null;
        }
        Object[] ls = this.list();
        if (ls == null) {
            return null;
        }
        Arrays.sort(ls);
        String decodedBase = URIUtil.decodePath((String)basePath);
        String title = Bundle.getMessage(this.locale, "DirectoryTitle", StringUtil.sanitizeXmlString((String)decodedBase));
        StringBuilder table = new StringBuilder(4096);
        String row = Bundle.getMessage(this.locale, "TableRow");
        if (parent) {
            table.append(String.format(this.locale, row, URIUtil.addPaths((String)basePath, (String)"../"), Bundle.getMessage(this.locale, "ParentDirectory"), "", ""));
        }
        String encodedBase = DirectoryResource.hrefEncodeURI(basePath);
        DateFormat dfmt = DateFormat.getDateTimeInstance(2, 2, this.locale);
        for (Object l : ls) {
            Resource item = this.addPath((String)l);
            Object itemPath = URIUtil.addPaths((String)encodedBase, (String)URIUtil.encodePath((String)l));
            if (item.isDirectory() && !((String)itemPath).endsWith("/")) {
                itemPath = (String)itemPath + "/";
            }
            table.append(String.format(this.locale, row, itemPath, StringUtil.sanitizeXmlString((String)l), Bundle.getMessage(this.locale, "SizeInBytes", item.length()), dfmt.format(new Date(item.lastModified()))));
        }
        return String.format(this.locale, FileUtil.readURL(FileUtil.findURL(Bundle.getMessage(this.locale, "Directory.html"))), String.format(this.locale, Bundle.getMessage(this.locale, "HtmlTitle"), InstanceManager.getDefault(ServletUtil.class).getRailroadName(false), title), InstanceManager.getDefault(ServletUtil.class).getNavBar(this.locale, basePath), InstanceManager.getDefault(ServletUtil.class).getRailroadName(false), InstanceManager.getDefault(ServletUtil.class).getFooter(this.locale, basePath), title, table);
    }

    public boolean equals(Object other) {
        return super.equals(other);
    }

    public int hashCode() {
        return super.hashCode();
    }

    private static String hrefEncodeURI(String raw) {
        char c;
        int i;
        StringBuilder buf = null;
        block9: for (i = 0; i < raw.length(); ++i) {
            c = raw.charAt(i);
            switch (c) {
                case '\"': 
                case '\'': 
                case '<': 
                case '>': {
                    buf = new StringBuilder(raw.length() << 1);
                    break block9;
                }
                default: {
                    log.debug("Unhandled code: {}", (Object)Character.valueOf(c));
                    continue block9;
                }
            }
        }
        if (buf == null) {
            return raw;
        }
        block10: for (i = 0; i < raw.length(); ++i) {
            c = raw.charAt(i);
            switch (c) {
                case '\"': {
                    buf.append("%22");
                    continue block10;
                }
                case '\'': {
                    buf.append("%27");
                    continue block10;
                }
                case '<': {
                    buf.append("%3C");
                    continue block10;
                }
                case '>': {
                    buf.append("%3E");
                    continue block10;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }
}

