/*
 * Decompiled with CFR 0.152.
 */
package jmri.web.servlet.directory;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jmri.web.servlet.directory.DirectoryResource;
import org.eclipse.jetty.server.ResourceService;
import org.eclipse.jetty.util.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryService
extends ResourceService {
    private static final Logger log = LoggerFactory.getLogger(DirectoryService.class);

    protected void notFound(HttpServletRequest request, HttpServletResponse response) throws IOException {
    }

    protected void sendDirectory(HttpServletRequest request, HttpServletResponse response, Resource resource, String pathInContext) throws IOException {
        if (this.isDirAllowed()) {
            log.debug("Sending !! {} for {} in context {}", new Object[]{request.getRequestURI(), resource.getName(), pathInContext});
            response.setStatus(200);
            response.setContentType("text/html; charset=utf-8");
            try (DirectoryResource r = new DirectoryResource(request.getLocale(), resource);){
                String dir = r.getListHTML(request.getRequestURI(), request.getPathInfo().lastIndexOf(47) > 0, request.getRequestURI());
                byte[] data = dir.getBytes(StandardCharsets.UTF_8);
                response.setContentLength(data.length);
                response.getOutputStream().write(data);
            }
        } else {
            response.sendError(403);
        }
    }
}

