/*
 * Decompiled with CFR 0.152.
 */
package jmri.web.servlet.frameimage;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import jmri.InstanceManager;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.LightIcon;
import jmri.jmrit.display.LocoIcon;
import jmri.jmrit.display.MemoryOrGVIcon;
import jmri.jmrit.display.MultiSensorIcon;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionableIcon;
import jmri.jmrit.display.PositionableLabel;
import jmri.jmrit.display.ReporterIcon;
import jmri.jmrit.display.RpsPositionIcon;
import jmri.jmrit.display.SlipTurnoutIcon;
import jmri.jmrit.display.TurnoutIcon;
import jmri.server.json.JsonException;
import jmri.server.json.util.JsonUtilHttpService;
import jmri.util.JmriJFrame;
import jmri.util.swing.JDialogListener;
import jmri.util.swing.JmriMouseEvent;
import jmri.web.server.WebServerPreferences;
import jmri.web.servlet.ServletUtil;
import jmri.web.servlet.frameimage.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="FrameServlet", urlPatterns={"/frame"})
public class JmriJFrameServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(JmriJFrameServlet.class);

    void sendClick(String name, @Nonnull Component c, int xg, int yg, Container frameContentPane) {
        int x = xg - c.getLocation().x;
        int y = yg - c.getLocation().y;
        log.debug("Local click at {},{} in {}", new Object[]{x, y, c.getClass()});
        if (c.getClass().equals(JButton.class)) {
            ((AbstractButton)c).doClick();
        } else if (c.getClass().equals(JToggleButton.class)) {
            ((AbstractButton)c).doClick();
        } else if (c.getClass().equals(JCheckBox.class)) {
            ((AbstractButton)c).doClick();
        } else if (c.getClass().equals(JRadioButton.class)) {
            ((AbstractButton)c).doClick();
        } else if (MouseListener.class.isAssignableFrom(c.getClass())) {
            log.debug("Invoke directly on MouseListener, at {},{}", (Object)x, (Object)y);
            this.sendClickSequence((MouseListener)((Object)c), c, x, y);
        } else if (c instanceof MultiSensorIcon) {
            log.debug("Invoke Clicked on MultiSensorIcon");
            JmriMouseEvent e = new JmriMouseEvent(c, 500, 0L, 0, xg, yg, 1, false);
            ((Positionable)((Object)c)).doMouseClicked(e);
        } else if (Positionable.class.isAssignableFrom(c.getClass())) {
            log.debug("Invoke Pressed, Released and Clicked on Positionable");
            JmriMouseEvent e = new JmriMouseEvent(c, 501, 0L, 0, x, y, 1, false);
            ((Positionable)((Object)c)).doMousePressed(e);
            e = new JmriMouseEvent(c, 502, 0L, 0, x, y, 1, false);
            ((Positionable)((Object)c)).doMouseReleased(e);
            e = new JmriMouseEvent(c, 500, 0L, 0, x, y, 1, false);
            ((Positionable)((Object)c)).doMouseClicked(e);
        } else {
            if (c instanceof JButton) {
                ((JButton)c).doClick();
                return;
            }
            MouseListener[] la = c.getMouseListeners();
            log.debug("Invoke {} contained mouse listeners", (Object)la.length);
            log.debug("component is {}", (Object)c);
            if (c instanceof JTable || c instanceof JTableHeader) {
                Rectangle rT = c.getBounds();
                Rectangle r = SwingUtilities.convertRectangle(c.getParent(), rT, frameContentPane);
                log.debug("New JTable x: {} and y: {}", (Object)(x += (int)rT.getX() - (int)r.getX()), (Object)(y += (int)rT.getY() - (int)r.getY()));
            }
            for (MouseListener ml : la) {
                log.trace("Send click sequence at {},{}", (Object)x, (Object)y);
                this.sendClickSequence(ml, c, x, y);
            }
        }
    }

    private void sendClickSequence(MouseListener m, Component c, int x, int y) {
        MouseEvent e = new MouseEvent(c, 504, 0L, 0, x, y, 1, false);
        m.mouseEntered(e);
        e = new MouseEvent(c, 501, 0L, 0, x, y, 1, false, 1);
        m.mousePressed(e);
        e = new MouseEvent(c, 502, 0L, 0, x, y, 1, false, 1);
        m.mouseReleased(e);
        e = new MouseEvent(c, 500, 0L, 0, x, y, 1, false, 1);
        m.mouseClicked(e);
        e = new MouseEvent(c, 505, 0L, 0, x, y, 1, false, 1);
        m.mouseExited(e);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doGetOnSwing(request, response);
            return;
        }
        try {
            SwingUtilities.invokeAndWait(() -> {
                try {
                    this.doGetOnSwing(request, response);
                }
                catch (IOException | ServletException ex) {
                    throw new RuntimeException(ex);
                }
            });
        }
        catch (InterruptedException ex) {
            log.trace("Ignoring InterruptedException");
        }
        catch (InvocationTargetException ex) {
            log.trace("top-level caught", (Throwable)ex);
            if (ex.getCause() != null) {
                log.trace("1st level caught", ex.getCause());
                if (ex.getCause().getCause() != null) {
                    Throwable ex2 = ex.getCause().getCause();
                    if (ex2 instanceof ServletException) {
                        throw (ServletException)ex2;
                    }
                    if (ex2 instanceof IOException) {
                        throw (IOException)ex2;
                    }
                    throw new RuntimeException(ex);
                }
                throw new RuntimeException(ex);
            }
            throw new RuntimeException(ex);
        }
    }

    protected void doGetOnSwing(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebServerPreferences preferences = InstanceManager.getDefault(WebServerPreferences.class);
        if (preferences.isDisableFrames()) {
            if (preferences.isRedirectFramesToPanels()) {
                if ("json".equals(request.getParameter("format"))) {
                    response.sendRedirect("/panel?format=json");
                } else {
                    response.sendRedirect("/panel");
                }
            } else {
                response.sendError(403, Bundle.getMessage(request.getLocale(), "FramesAreDisabled"));
            }
            return;
        }
        JmriJFrame frame = null;
        String name = this.getFrameName(request.getRequestURI());
        if (name != null) {
            List<String> disallowedFrames = Arrays.asList(preferences.getDisallowedFrames());
            if (disallowedFrames.contains(name)) {
                response.sendError(403, "Frame [" + name + "] not allowed (check Preferences)");
                return;
            }
            frame = JmriJFrame.getFrame(name);
            if (frame == null) {
                response.sendError(404, "Can not find frame [" + name + "]");
                return;
            }
            if (!frame.isVisible()) {
                response.sendError(403, "Frame [" + name + "] hidden");
            } else if (!frame.getAllowInFrameServlet()) {
                response.sendError(403, "Frame [" + name + "] not allowed by design");
                return;
            }
        }
        Map<String, String[]> parameters = this.populateParameterMap(request.getParameterMap());
        if (!(frame == null || !parameters.containsKey("coords") || parameters.containsKey("protect") && Boolean.parseBoolean(parameters.get("protect")[0]))) {
            this.doClick(frame, parameters.get("coords")[0]);
        }
        if (frame != null && request.getRequestURI().contains(".html")) {
            this.doHtml(frame, request, response, parameters);
        } else if (frame != null && request.getRequestURI().contains(".png")) {
            this.doImage(frame, request, response);
        } else {
            this.doList(request, response);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private void doHtml(@Nonnull JmriJFrame frame, HttpServletRequest request, @Nonnull HttpServletResponse response, Map<String, String[]> parameters) throws ServletException, IOException {
        WebServerPreferences preferences = InstanceManager.getDefault(WebServerPreferences.class);
        Date now = new Date();
        boolean click = false;
        boolean useAjax = preferences.isUseAjax();
        boolean plain = preferences.isSimple();
        String clickRetryTime = Integer.toString(preferences.getClickDelay());
        String noclickRetryTime = Integer.toString(preferences.getRefreshDelay());
        boolean protect = false;
        if (parameters.containsKey("coords")) {
            click = true;
        }
        if (parameters.containsKey("retry")) {
            noclickRetryTime = parameters.get("retry")[0];
        }
        if (parameters.containsKey("ajax")) {
            useAjax = Boolean.parseBoolean(parameters.get("ajax")[0]);
        }
        if (parameters.containsKey("plain")) {
            plain = Boolean.parseBoolean(parameters.get("plain")[0]);
        }
        if (parameters.containsKey("protect")) {
            protect = Boolean.parseBoolean(parameters.get("protect")[0]);
        }
        response.setStatus(200);
        response.setContentType("text/html");
        response.setHeader("Connection", "Keep-Alive");
        response.setDateHeader("Date", now.getTime());
        response.setDateHeader("Last-Modified", now.getTime());
        response.setDateHeader("Expires", now.getTime());
        Object[] args = new String[]{"localhost", URLEncoder.encode(frame.getTitle(), ServletUtil.UTF8), click ? clickRetryTime : noclickRetryTime, noclickRetryTime, Boolean.toString(plain), plain ? "-plain" : "", Boolean.toString(useAjax), Boolean.toString(protect)};
        response.getWriter().write(Bundle.getMessage(request.getLocale(), "FrameDocType"));
        response.getWriter().write(MessageFormat.format(Bundle.getMessage(request.getLocale(), "FramePart1"), args));
        if (useAjax) {
            response.getWriter().write(MessageFormat.format(Bundle.getMessage(request.getLocale(), "FramePart2Ajax"), args));
        } else {
            response.getWriter().write(MessageFormat.format(Bundle.getMessage(request.getLocale(), "FramePart2NonAjax"), args));
        }
        response.getWriter().write(MessageFormat.format(Bundle.getMessage(request.getLocale(), "FrameFooter"), args));
        log.debug("Sent jframe html with click={}", (Object)(click ? "True" : "False"));
    }

    private void doImage(@Nonnull JmriJFrame frame, HttpServletRequest request, @Nonnull HttpServletResponse response) throws ServletException, IOException {
        Date now = new Date();
        response.setStatus(200);
        response.setContentType("image/png");
        response.setDateHeader("Date", now.getTime());
        response.setDateHeader("Last-Modified", now.getTime());
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Connection", "Keep-Alive");
        response.setHeader("Keep-Alive", "timeout=5, max=100");
        BufferedImage image = new BufferedImage(frame.getContentPane().getWidth(), frame.getContentPane().getHeight(), 1);
        frame.getContentPane().paint(image.createGraphics());
        this.doDialog(JmriJFrameServlet.getDialog(frame), image);
        ByteArrayOutputStream tmpFile = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", tmpFile);
        tmpFile.close();
        response.setContentLength(tmpFile.size());
        response.getOutputStream().write(tmpFile.toByteArray());
        log.debug("Sent [{}] as {} byte png.", (Object)frame.getTitle(), (Object)tmpFile.size());
    }

    private void doDialog(@CheckForNull JDialog dialog, @Nonnull BufferedImage image) {
        if (dialog == null) {
            return;
        }
        log.debug("dialog {}", (Object)dialog);
        BufferedImage dImage = new BufferedImage(dialog.getContentPane().getWidth(), dialog.getContentPane().getHeight(), 1);
        dialog.getContentPane().paint(dImage.createGraphics());
        image.getGraphics().drawImage(dImage, 0, 20, null);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, dialog.getContentPane().getWidth(), 20);
        g.setColor(Color.DARK_GRAY);
        g.drawRect(0, 0, dialog.getContentPane().getWidth(), dialog.getContentPane().getHeight() + 20);
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setRenderingHints(hints);
        g.drawString(dialog.getTitle(), 10, 15);
    }

    private void doList(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) throws ServletException, IOException {
        List<String> disallowedFrames = Arrays.asList(InstanceManager.getDefault(WebServerPreferences.class).getDisallowedFrames());
        String format = request.getParameter("format");
        ObjectMapper mapper = new ObjectMapper();
        Date now = new Date();
        boolean usePanels = Boolean.parseBoolean(request.getParameter("panels"));
        response.setStatus(200);
        if ("json".equals(format)) {
            response.setContentType("application/json");
        } else {
            response.setContentType("text/html");
        }
        response.setHeader("Connection", "Keep-Alive");
        response.setDateHeader("Date", now.getTime());
        response.setDateHeader("Last-Modified", now.getTime());
        response.setDateHeader("Expires", now.getTime());
        if ("json".equals(format)) {
            ArrayNode root = mapper.createArrayNode();
            HashSet<JFrame> frames = new HashSet<JFrame>();
            JsonUtilHttpService service = new JsonUtilHttpService(new ObjectMapper());
            for (JmriJFrame frame : JmriJFrame.getFrameList()) {
                if (frame == null) continue;
                if (usePanels && frame instanceof Editor) {
                    ObjectNode node = service.getPanel((Editor)frame, "xml", 0);
                    if (node == null) continue;
                    root.add((JsonNode)node);
                    frames.add(((Editor)frame).getTargetFrame());
                    continue;
                }
                String title = frame.getTitle();
                if (title.isEmpty() || !frame.getAllowInFrameServlet() || disallowedFrames.contains(title) || frames.contains(frame) || !frame.isVisible()) continue;
                ObjectNode node = mapper.createObjectNode();
                try {
                    node.put("name", title);
                    node.put("URL", "/frame/" + URLEncoder.encode(title, ServletUtil.UTF8) + ".html");
                    node.put("png", "/frame/" + URLEncoder.encode(title, ServletUtil.UTF8) + ".png");
                    root.add((JsonNode)node);
                    frames.add(frame);
                }
                catch (UnsupportedEncodingException ex) {
                    JsonException je = new JsonException(500, "Unable to encode panel title \"" + title + "\"", 0);
                    response.sendError(je.getCode(), mapper.writeValueAsString((Object)je.getJsonMessage()));
                    return;
                }
            }
            response.getWriter().write(mapper.writeValueAsString((Object)root));
        } else {
            response.getWriter().append(Bundle.getMessage(request.getLocale(), "FrameDocType"));
            response.getWriter().append(Bundle.getMessage(request.getLocale(), "ListFront"));
            response.getWriter().write(Bundle.getMessage(request.getLocale(), "TableHeader"));
            for (JmriJFrame frame : JmriJFrame.getFrameList()) {
                String title = frame.getTitle();
                if (title.isEmpty() || !frame.getAllowInFrameServlet() || disallowedFrames.contains(title) || !frame.isVisible()) continue;
                String link = "/frame/" + URLEncoder.encode(title, ServletUtil.UTF8) + ".html";
                response.getWriter().append("<tr><td><a href='" + link + "'>");
                response.getWriter().append(title);
                response.getWriter().append("</a></td>");
                response.getWriter().append("<td><a href='");
                response.getWriter().append(link);
                response.getWriter().append("'><img src='");
                response.getWriter().append("/frame/" + URLEncoder.encode(title, ServletUtil.UTF8) + ".png");
                response.getWriter().append("'></a></td></tr>\n");
            }
            response.getWriter().append("</table>");
            response.getWriter().append(Bundle.getMessage(request.getLocale(), "ListFooter"));
        }
    }

    private String getFrameName(@Nonnull String uri) throws UnsupportedEncodingException {
        if (!uri.contains(".")) {
            return null;
        }
        int stop = uri.contains("?") ? uri.indexOf(63) : uri.length();
        String name = uri.substring(uri.lastIndexOf(47), stop);
        name = name.substring(1, name.lastIndexOf(46));
        name = URLDecoder.decode(name, ServletUtil.UTF8);
        log.debug("Frame name is {}", (Object)name);
        return name;
    }

    protected Map<String, String[]> populateParameterMap(@Nonnull Map<String, String[]> map) {
        HashMap<String, String[]> parameters = new HashMap<String, String[]>();
        map.entrySet().stream().forEach(entry -> {
            String[] value = (String[])entry.getValue();
            String key = (String)entry.getKey();
            if (value[0].contains("?")) {
                String[] values = value[0].split("\\?");
                if (values[0].contains(",")) {
                    parameters.put(key, new String[]{values[1]});
                    parameters.put("coords", new String[]{values[0]});
                } else {
                    parameters.put(key, new String[]{values[0]});
                    parameters.put("coords", new String[]{values[1]});
                }
            } else if (key.contains(",")) {
                String[] coords = new String[1];
                if (key.contains("?")) {
                    coords[0] = key.substring(key.indexOf("?"));
                    key = key.substring(0, key.indexOf("?") - 1);
                    parameters.put(key, value);
                } else {
                    coords[0] = key;
                }
                log.debug("Setting click coords to {}", (Object)coords[0]);
                parameters.put("coords", coords);
            } else {
                parameters.put(key, value);
            }
        });
        return parameters;
    }

    private void doClick(@Nonnull JmriJFrame frame, @Nonnull String coords) {
        String[] click = coords.split(",");
        int x = Integer.parseInt(click[0]);
        int y = Integer.parseInt(click[1]);
        JDialog dialog = JmriJFrameServlet.getDialog(frame);
        if (dialog != null) {
            Component cc = dialog.getContentPane().findComponentAt(x, y -= 20);
            if (cc != null) {
                log.debug("click dialog {} at x:{} y:{} component:{}", new Object[]{dialog.getTitle(), x, y, cc});
                this.sendClick(frame.getTitle(), cc, x, y, dialog.getContentPane());
            }
            return;
        }
        Component c = frame.getContentPane().findComponentAt(x, y);
        if (c == null) {
            return;
        }
        this.sendClick(frame.getTitle(), c, x, y, frame.getContentPane());
        if (!(c.getClass().getName().equals("jmri.jmrit.display.Editor$TargetPane") || !(c instanceof PositionableLabel) || c instanceof LightIcon || c instanceof LocoIcon || c instanceof MemoryOrGVIcon || c instanceof MultiSensorIcon || c instanceof PositionableIcon || c instanceof ReporterIcon || c instanceof RpsPositionIcon || c instanceof SlipTurnoutIcon || c instanceof TurnoutIcon)) {
            this.clickOnEditorPane(frame.getContentPane(), x, y, frame);
        }
    }

    public void clickOnEditorPane(@Nonnull Component c, int x, int y, JmriJFrame f) {
        if (c.getClass().getName().equals("jmri.jmrit.display.Editor$TargetPane")) {
            log.debug("Sending additional click to Editor$TargetPane");
            this.sendClick(f.getTitle(), c, x, y, f);
        } else if (c instanceof Container) {
            for (Component child : ((Container)c).getComponents()) {
                this.clickOnEditorPane(child, x, y, f);
            }
        }
    }

    @CheckForNull
    private static JDialog getDialog(@Nonnull JmriJFrame frame) {
        for (PropertyChangeListener pcl : frame.getPropertyChangeListeners()) {
            log.debug("PCL : {}", (Object)pcl);
            if (!(pcl instanceof JDialogListener)) continue;
            return ((JDialogListener)pcl).getDialog();
        }
        return null;
    }
}

