/*
 * Decompiled with CFR 0.152.
 */
package jmri.web.servlet.help;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jmri.util.FileUtil;
import org.eclipse.jetty.server.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="HelpSSIServlet", urlPatterns={"/help", "/plugin"})
public class HelpSSIServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(HelpSSIServlet.class);

    private void handleRegularFile(String fileName, HttpServletResponse response) throws IOException {
        String ext;
        response.setHeader("Connection", "Keep-Alive");
        switch (ext = fileName.substring(fileName.lastIndexOf(46) + 1).toLowerCase()) {
            case "svg": {
                response.setContentType("image/svg");
                break;
            }
            case "png": {
                response.setContentType("image/png");
                break;
            }
            case "gif": {
                response.setContentType("image/gif");
                break;
            }
            case "jpg": 
            case "jpeg": {
                response.setContentType("image/jpeg");
                break;
            }
            case "js": {
                response.setContentType("application/javascript");
                break;
            }
            default: {
                response.setContentType("application/octet-stream");
            }
        }
        byte[] b = new byte[1024];
        if (fileName.startsWith("/plugin/")) {
            String resourceName = fileName.substring("/plugin/".length());
            try (InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resourceName);){
                if (inputStream != null) {
                    int byteRead;
                    while ((byteRead = inputStream.read(b)) != -1) {
                        response.getOutputStream().write(b, 0, byteRead);
                    }
                }
                String error = String.format("--- ERROR: Plugin resource \"%s\" couldn't be found", resourceName);
                response.getOutputStream().write(error.getBytes());
                log.warn(error);
            }
        } else {
            try (FileInputStream inputStream = new FileInputStream(fileName);){
                int byteRead;
                while ((byteRead = ((InputStream)inputStream).read(b)) != -1) {
                    response.getOutputStream().write(b, 0, byteRead);
                }
            }
        }
        response.getOutputStream().flush();
    }

    private String convertDotDotFolders(String theFileName, String path) {
        if (((String)theFileName).startsWith("../")) {
            String[] paths = path.split("/");
            int numDotDots = 0;
            while (((String)theFileName).startsWith("../")) {
                theFileName = ((String)theFileName).substring(3);
                ++numDotDots;
            }
            if (numDotDots < paths.length) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < paths.length - numDotDots; ++i) {
                    sb.append(paths[i]).append('/');
                }
                theFileName = sb.toString() + (String)theFileName;
            } else {
                theFileName = "/" + (String)theFileName;
            }
        }
        return theFileName;
    }

    private String quoteBackslash(String content) {
        return content.replaceAll("\\\\", "\\\\\\\\");
    }

    private String readAndParseFile(String fileName) throws IOException {
        Object content;
        String path;
        block17: {
            log.debug("readAndParseFile('{}')", fileName);
            int lastSlash = ((String)fileName).lastIndexOf(47);
            String string = path = lastSlash != -1 ? ((String)fileName).substring(0, lastSlash + 1) : "";
            if (!((String)fileName).startsWith("/plugin/")) {
                fileName = FileUtil.getProgramPath() + (String)fileName;
            }
            try {
                if (((String)fileName).startsWith("/plugin/")) {
                    String resourceName = ((String)fileName).substring("/plugin/".length());
                    try (InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resourceName);){
                        if (is != null) {
                            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                                String line;
                                StringBuilder sb = new StringBuilder();
                                while ((line = reader.readLine()) != null) {
                                    sb.append(line);
                                }
                                content = sb.toString();
                                break block17;
                            }
                        }
                        content = String.format("%n<br>%nERROR: Plugin resource \"%s\" couldn't be found%n<br>%n", resourceName);
                        log.warn("Plugin resource \"{}\" couldn't be found", (Object)resourceName);
                        break block17;
                    }
                }
                content = new String(Files.readAllBytes(Paths.get((String)fileName, new String[0])));
            }
            catch (IOException ex) {
                content = "Exception thrown: " + ex.getMessage();
                log.warn("Cannot read file: {}", fileName, (Object)ex);
            }
        }
        String serverSideIncludePattern = "<!--#include\\s*virtual=\"(.+?)\"\\s*-->";
        Pattern pattern = Pattern.compile(serverSideIncludePattern);
        Matcher matcher = pattern.matcher((CharSequence)content);
        content = matcher.replaceAll(t -> {
            String theFileName = t.group(1);
            try {
                theFileName = this.convertDotDotFolders(theFileName, path);
                if (path.startsWith("/")) {
                    if (theFileName.startsWith("/")) {
                        return this.quoteBackslash(this.readAndParseFile(theFileName));
                    }
                    return this.quoteBackslash(this.readAndParseFile(path + theFileName));
                }
                return this.quoteBackslash(this.readAndParseFile("web/" + path + theFileName));
            }
            catch (IOException ex) {
                log.warn("Cannot include SSI: {}", (Object)theFileName, (Object)ex);
                return "";
            }
        });
        return content;
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String uri = request.getRequestURI();
        if (!uri.endsWith(".shtml")) {
            if (!(request instanceof Request)) {
                throw new IllegalArgumentException("request is not a Request");
            }
            log.debug("Handling regular file: '{}'", (Object)uri);
            Object fileName = uri;
            if (!((String)fileName).startsWith("/plugin/")) {
                fileName = FileUtil.getProgramPath() + uri;
            }
            this.handleRegularFile((String)fileName, response);
            return;
        }
        log.debug("Handling .shtml  file: '{}'", (Object)uri);
        String content = this.readAndParseFile(uri);
        response.setHeader("Connection", "Keep-Alive");
        response.setContentType("text/html; charset=utf-8");
        response.getWriter().write(content);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Help SSI Servlet";
    }
}

