/*
 * Decompiled with CFR 0.152.
 */
package jmri.web.servlet.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Reader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jmri.InstanceManager;
import jmri.server.json.JSON;
import jmri.server.json.JsonException;
import jmri.server.json.JsonHttpService;
import jmri.server.json.JsonRequest;
import jmri.server.json.JsonServerPreferences;
import jmri.server.json.JsonWebSocket;
import jmri.server.json.schema.JsonSchemaServiceCache;
import jmri.spi.JsonServiceFactory;
import jmri.util.FileUtil;
import jmri.web.servlet.ServletUtil;
import jmri.web.servlet.json.Bundle;
import jmri.web.servlet.json.JsonBundle;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="JsonServlet", urlPatterns={"/json"})
public class JsonServlet
extends WebSocketServlet {
    private final transient ObjectMapper mapper = new ObjectMapper();
    private final transient HashMap<String, HashMap<String, HashSet<JsonHttpService>>> services = new HashMap();
    private final transient JsonServerPreferences preferences = InstanceManager.getDefault(JsonServerPreferences.class);
    private static final Logger log = LoggerFactory.getLogger(JsonServlet.class);

    public void init() throws ServletException {
        this.superInit();
        ServiceLoader.load(JsonServiceFactory.class).forEach(factory -> JSON.VERSIONS.stream().forEach(version -> {
            Object service = factory.getHttpService(this.mapper, (String)version);
            HashMap types = this.services.computeIfAbsent((String)version, map -> new HashMap());
            Arrays.stream(factory.getTypes((String)version)).forEach(type -> types.computeIfAbsent(type, set -> new HashSet()).add(service));
            Arrays.stream(factory.getReceivedTypes((String)version)).forEach(type -> types.computeIfAbsent(type, set -> new HashSet()).add(service));
        }));
    }

    void superInit() throws ServletException {
        super.init();
    }

    public void configure(WebSocketServletFactory factory) {
        factory.register(JsonWebSocket.class);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String type;
        String[] path;
        this.configureResponse(response);
        JsonRequest jsonRequest = this.createJsonRequest(request);
        String[] rest = path = request.getRequestURI().substring(request.getContextPath().length()).split("/");
        if (path.length > 1 && jsonRequest.version.equals(path[1])) {
            rest = Arrays.copyOfRange(path, 1, path.length);
        }
        if (request.getAttribute("result") != null) {
            JsonNode result = (JsonNode)request.getAttribute("result");
            int code = result.path("data").path("code").asInt(200);
            this.sendMessage(response, code, result, jsonRequest);
            return;
        }
        String string = type = rest.length > 1 ? URLDecoder.decode(rest[1], ServletUtil.UTF8) : null;
        if (type != null && !type.isEmpty()) {
            JsonNode reply;
            block32: {
                response.setContentType("application/json; charset=utf-8");
                InstanceManager.getDefault(ServletUtil.class).setNonCachingHeaders(response);
                String name = rest.length > 2 ? URLDecoder.decode(rest[2], ServletUtil.UTF8) : null;
                ObjectNode parameters = this.mapper.createObjectNode();
                for (Map.Entry entry : request.getParameterMap().entrySet()) {
                    String value = URLDecoder.decode(((String[])entry.getValue())[0], ServletUtil.UTF8);
                    log.debug("Setting parameter {} to {}", entry.getKey(), (Object)value);
                    try {
                        parameters.setAll((ObjectNode)this.mapper.readTree(String.format("{\"%s\":%s}", entry.getKey(), value)));
                    }
                    catch (JsonProcessingException ex) {
                        log.error("Unable to parse JSON {\"{}\":{}}", entry.getKey(), (Object)value);
                    }
                }
                reply = null;
                try {
                    if (name == null) {
                        if (this.services.get(jsonRequest.version).get(type) != null) {
                            ArrayList<JsonNode> lists = new ArrayList<JsonNode>();
                            ArrayNode array = this.mapper.createArrayNode();
                            JsonException exception = null;
                            try {
                                for (JsonHttpService service : this.services.get(jsonRequest.version).get(type)) {
                                    lists.add(service.doGetList(type, (JsonNode)parameters, jsonRequest));
                                }
                            }
                            catch (JsonException ex) {
                                exception = ex;
                            }
                            switch (lists.size()) {
                                case 0: {
                                    if (exception != null) {
                                        throw exception;
                                    }
                                    reply = JsonHttpService.message(this.mapper, array, null, jsonRequest.id);
                                    break;
                                }
                                case 1: {
                                    reply = (JsonNode)lists.get(0);
                                    break;
                                }
                                default: {
                                    for (JsonNode list : lists) {
                                        if (list.isArray()) {
                                            list.forEach(arg_0 -> ((ArrayNode)array).add(arg_0));
                                            continue;
                                        }
                                        if (!list.path("data").isArray()) continue;
                                        list.path("data").forEach(arg_0 -> ((ArrayNode)array).add(arg_0));
                                    }
                                    reply = JsonHttpService.message(this.mapper, array, null, jsonRequest.id);
                                }
                            }
                        }
                        if (reply == null) {
                            log.warn("Requested type '{}' unknown.", (Object)type);
                            throw new JsonException(404, JsonBundle.getMessage(request.getLocale(), "ErrorUnknownType", type), jsonRequest.id);
                        }
                        break block32;
                    }
                    if (this.services.get(jsonRequest.version).get(type) != null) {
                        ArrayNode array = this.mapper.createArrayNode();
                        JsonException exception = null;
                        try {
                            for (JsonHttpService service : this.services.get(jsonRequest.version).get(type)) {
                                array.add(service.doGet(type, name, (JsonNode)parameters, jsonRequest));
                            }
                        }
                        catch (JsonException ex) {
                            exception = ex;
                        }
                        switch (array.size()) {
                            case 0: {
                                if (exception != null) {
                                    throw exception;
                                }
                                reply = array;
                                break;
                            }
                            case 1: {
                                reply = array.get(0);
                                break;
                            }
                            default: {
                                reply = array;
                            }
                        }
                    }
                    if (reply == null) {
                        log.warn("Requested type '{}' unknown.", (Object)type);
                        throw new JsonException(404, JsonBundle.getMessage(request.getLocale(), "ErrorUnknownType", type), jsonRequest.id);
                    }
                }
                catch (JsonException ex) {
                    reply = ex.getJsonMessage();
                }
            }
            int code = reply.path("data").path("code").asInt(200);
            this.sendMessage(response, code, reply, jsonRequest);
        } else {
            ServletUtil util = InstanceManager.getDefault(ServletUtil.class);
            response.setContentType("text/html; charset=utf-8");
            response.getWriter().print(String.format(request.getLocale(), FileUtil.readURL(FileUtil.findURL(Bundle.getMessage(request.getLocale(), "Json.html"))), util.getTitle(request.getLocale(), Bundle.getMessage(request.getLocale(), "JsonTitle")), util.getNavBar(request.getLocale(), request.getContextPath()), util.getRailroadName(false), util.getFooter(request.getLocale(), request.getContextPath())));
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        JsonNode reply;
        JsonRequest jsonRequest;
        block28: {
            String[] path;
            this.configureResponse(response);
            InstanceManager.getDefault(ServletUtil.class).setNonCachingHeaders(response);
            jsonRequest = this.createJsonRequest(request);
            String[] rest = path = request.getRequestURI().substring(request.getContextPath().length()).split("/");
            if (path.length >= 1 && jsonRequest.version.equals(path[1])) {
                rest = Arrays.copyOfRange(path, 1, path.length);
            }
            String type = rest.length > 1 ? URLDecoder.decode(rest[1], ServletUtil.UTF8) : null;
            String name = rest.length > 2 ? URLDecoder.decode(rest[2], ServletUtil.UTF8) : null;
            int id = 0;
            try {
                id = Integer.parseInt(request.getParameter("id"));
            }
            catch (NumberFormatException ex) {
                id = 0;
            }
            reply = null;
            try {
                ObjectNode data;
                if (request.getContentType().contains("application/json")) {
                    data = this.mapper.readTree((Reader)request.getReader());
                    if (!data.path("data").isMissingNode()) {
                        data = data.path("data");
                    }
                } else {
                    data = this.mapper.createObjectNode();
                    if (request.getParameter("state") != null) {
                        data.put("state", Integer.parseInt(request.getParameter("state")));
                    } else if (request.getParameter("location") != null) {
                        data.put("location", request.getParameter("location"));
                    } else if (request.getParameter("value") != null) {
                        data.put("value", request.getParameter("value"));
                    }
                }
                if (type != null) {
                    if (type.equals("power")) {
                        name = "power";
                    } else if (name == null) {
                        name = data.path("name").asText();
                    }
                    log.debug("POST operation for {}/{} with {}", new Object[]{type, name, data});
                    if (name != null) {
                        if (this.services.get(jsonRequest.version).get(type) != null) {
                            log.debug("Using data: {}", (Object)data);
                            ArrayNode array = this.mapper.createArrayNode();
                            JsonException exception = null;
                            try {
                                for (JsonHttpService service : this.services.get(jsonRequest.version).get(type)) {
                                    array.add(service.doPost(type, name, (JsonNode)data, jsonRequest));
                                }
                            }
                            catch (JsonException ex) {
                                exception = ex;
                            }
                            switch (array.size()) {
                                case 0: {
                                    if (exception != null) {
                                        throw exception;
                                    }
                                    reply = array;
                                    break;
                                }
                                case 1: {
                                    reply = array.get(0);
                                    break;
                                }
                                default: {
                                    reply = array;
                                }
                            }
                        }
                        if (reply == null) {
                            log.warn("Requested type '{}' unknown.", (Object)type);
                            throw new JsonException(404, JsonBundle.getMessage(request.getLocale(), "ErrorUnknownType", type), id);
                        }
                        break block28;
                    }
                    log.error("Name must be defined.");
                    throw new JsonException(400, JsonBundle.getMessage(request.getLocale(), "ErrorMissingName"), id);
                }
                log.warn("Type not specified.");
                throw new JsonException(400, "Type must be specified.", id);
            }
            catch (JsonException ex) {
                reply = ex.getJsonMessage();
            }
        }
        int code = reply.path("data").path("code").asInt(200);
        this.sendMessage(response, code, reply, jsonRequest);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws IOException {
        JsonNode reply;
        JsonRequest jsonRequest;
        block21: {
            String[] path;
            this.configureResponse(response);
            InstanceManager.getDefault(ServletUtil.class).setNonCachingHeaders(response);
            jsonRequest = this.createJsonRequest(request);
            String[] rest = path = request.getRequestURI().substring(request.getContextPath().length()).split("/");
            if (path.length >= 1 && jsonRequest.version.equals(path[1])) {
                rest = Arrays.copyOfRange(path, 1, path.length);
            }
            String type = rest.length > 1 ? URLDecoder.decode(rest[1], ServletUtil.UTF8) : null;
            String name = rest.length > 2 ? URLDecoder.decode(rest[2], ServletUtil.UTF8) : null;
            reply = null;
            try {
                JsonNode data;
                if (request.getContentType().contains("application/json")) {
                    data = this.mapper.readTree((Reader)request.getReader());
                    if (!data.path("data").isMissingNode()) {
                        data = data.path("data");
                    }
                } else {
                    throw new JsonException(400, "PUT request must be a JSON object", jsonRequest.id);
                }
                if (type != null) {
                    if (type.equals("power")) {
                        name = "power";
                    } else if (name == null) {
                        name = data.path("name").asText();
                    }
                    if (name != null) {
                        if (this.services.get(jsonRequest.version).get(type) != null) {
                            ArrayNode array = this.mapper.createArrayNode();
                            JsonException exception = null;
                            try {
                                for (JsonHttpService service : this.services.get(jsonRequest.version).get(type)) {
                                    array.add(service.doPut(type, name, data, jsonRequest));
                                }
                            }
                            catch (JsonException ex) {
                                exception = ex;
                            }
                            switch (array.size()) {
                                case 0: {
                                    if (exception != null) {
                                        throw exception;
                                    }
                                    reply = array;
                                    break;
                                }
                                case 1: {
                                    reply = array.get(0);
                                    break;
                                }
                                default: {
                                    reply = array;
                                }
                            }
                        }
                        if (reply == null) {
                            throw new JsonException(400, type + " is not a creatable type", jsonRequest.id);
                        }
                        break block21;
                    }
                    log.warn("Requested type '{}' unknown.", (Object)type);
                    throw new JsonException(404, JsonBundle.getMessage(request.getLocale(), "ErrorUnknownType", type), jsonRequest.id);
                }
                log.warn("Type not specified.");
                throw new JsonException(400, "Type must be specified.", jsonRequest.id);
            }
            catch (JsonException ex) {
                reply = ex.getJsonMessage();
            }
        }
        int code = reply.path("data").path("code").asInt(200);
        this.sendMessage(response, code, reply, jsonRequest);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ObjectNode reply;
        JsonRequest jsonRequest;
        block9: {
            String[] path;
            this.configureResponse(response);
            InstanceManager.getDefault(ServletUtil.class).setNonCachingHeaders(response);
            jsonRequest = this.createJsonRequest(request);
            String[] rest = path = request.getRequestURI().substring(request.getContextPath().length()).split("/");
            if (path.length >= 1 && jsonRequest.version.equals(path[1])) {
                rest = Arrays.copyOfRange(path, 1, path.length);
            }
            String type = rest.length > 1 ? URLDecoder.decode(rest[1], ServletUtil.UTF8) : null;
            String name = rest.length > 2 ? URLDecoder.decode(rest[2], ServletUtil.UTF8) : null;
            reply = this.mapper.createObjectNode();
            try {
                if (type != null) {
                    if (name == null) {
                        throw new JsonException(400, "name must be specified", jsonRequest.id);
                    }
                    if (this.services.get(jsonRequest.version).get(type) != null) {
                        ObjectNode data = this.mapper.createObjectNode();
                        if (request.getContentType().contains("application/json") && !(data = this.mapper.readTree((Reader)request.getReader())).path("data").isMissingNode()) {
                            data = data.path("data");
                        }
                        for (JsonHttpService service : this.services.get(jsonRequest.version).get(type)) {
                            service.doDelete(type, name, (JsonNode)data, jsonRequest);
                        }
                        break block9;
                    }
                    log.warn("Requested type '{}' unknown.", (Object)type);
                    throw new JsonException(404, JsonBundle.getMessage(request.getLocale(), "ErrorUnknownType", type), jsonRequest.id);
                }
                log.debug("Type not specified.");
                throw new JsonException(400, "Type must be specified.", jsonRequest.id);
            }
            catch (JsonException ex) {
                reply = ex.getJsonMessage();
            }
        }
        int code = reply.path("data").path("code").asInt(200);
        if (code != 200) {
            this.sendMessage(response, code, (JsonNode)reply, jsonRequest);
        }
    }

    private JsonRequest createJsonRequest(HttpServletRequest request) {
        String[] path;
        int id = 0;
        String version = "v5";
        String idParameter = request.getParameter("id");
        if (idParameter != null) {
            try {
                id = Integer.parseInt(idParameter);
            }
            catch (NumberFormatException ex) {
                id = 0;
            }
        }
        if ((path = request.getRequestURI().substring(request.getContextPath().length()).split("/")).length > 1 && JSON.VERSIONS.stream().anyMatch(v -> v.equals(path[1]))) {
            version = path[1];
        }
        return new JsonRequest(request.getLocale(), version, request.getMethod().toLowerCase(), id);
    }

    private void configureResponse(HttpServletResponse response) {
        response.setStatus(200);
        response.setContentType("application/json; charset=utf-8");
        response.setHeader("Connection", "Keep-Alive");
    }

    private void sendMessage(@Nonnull HttpServletResponse response, int code, @Nonnull JsonNode message, @Nonnull JsonRequest request) throws IOException {
        if (this.preferences.getValidateServerMessages()) {
            try {
                InstanceManager.getDefault(JsonSchemaServiceCache.class).validateMessage(message, true, request);
            }
            catch (JsonException ex) {
                response.setStatus(500);
                response.getWriter().write(this.mapper.writeValueAsString((Object)ex.getJsonMessage()));
                return;
            }
        }
        response.setStatus(code);
        response.getWriter().write(this.mapper.writeValueAsString((Object)message));
    }
}

