/*
 * Decompiled with CFR 0.152.
 */
package jmri.web.servlet.operations;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.JsonManifest;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManifestHeaderText;
import jmri.jmrit.operations.trains.schedules.TrainScheduleManager;
import jmri.web.servlet.operations.HtmlTrainCommon;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlManifest
extends HtmlTrainCommon {
    protected ObjectMapper mapper = new ObjectMapper();
    private JsonNode jsonManifest = null;
    private static final Logger log = LoggerFactory.getLogger(HtmlManifest.class);

    public HtmlManifest(Locale locale, Train train) throws IOException {
        super(locale, train);
        this.resourcePrefix = "Manifest";
    }

    public String getLocations() throws IOException {
        if (this.getJsonManifest() == null) {
            return "Error manifest file not found for this train";
        }
        StringBuilder builder = new StringBuilder();
        JsonNode locations = this.getJsonManifest().path("locations");
        String previousLocationName = null;
        for (JsonNode location : locations) {
            boolean hasWork;
            RouteLocation routeLocation = this.train.getRoute().getRouteLocationById(location.path("name").textValue());
            log.debug("Processing {} ({})", (Object)routeLocation.getName(), (Object)location.path("name").textValue());
            String routeLocationName = location.path("userName").textValue();
            builder.append(String.format(this.locale, this.strings.getProperty("LocationStart"), routeLocation.getId()));
            boolean bl = hasWork = location.path("cars").path("add").size() > 0 || location.path("cars").path("remove").size() > 0 || location.path("engines").path("add").size() > 0 || location.path("engines").path("remove").size() > 0;
            if (hasWork && !routeLocationName.equals(previousLocationName)) {
                if (!this.train.isShowArrivalAndDepartureTimesEnabled()) {
                    builder.append(String.format(this.locale, this.strings.getProperty("ScheduledWorkAt"), routeLocationName));
                } else if (routeLocation == this.train.getTrainDepartsRouteLocation()) {
                    builder.append(String.format(this.locale, this.strings.getProperty("WorkDepartureTime"), routeLocationName, this.train.getFormatedDepartureTime()));
                } else if (!routeLocation.getDepartureTime().equals("")) {
                    builder.append(String.format(this.locale, this.strings.getProperty("WorkDepartureTime"), routeLocationName, routeLocation.getFormatedDepartureTime()));
                } else if (Setup.isUseDepartureTimeEnabled() && routeLocation != this.train.getTrainTerminatesRouteLocation()) {
                    builder.append(String.format(this.locale, this.strings.getProperty("WorkDepartureTime"), routeLocationName, this.train.getExpectedDepartureTime(routeLocation)));
                } else if (!this.train.getExpectedArrivalTime(routeLocation).equals("-1")) {
                    builder.append(String.format(this.locale, this.strings.getProperty("WorkArrivalTime"), routeLocationName, this.train.getExpectedArrivalTime(routeLocation)));
                } else {
                    builder.append(String.format(this.locale, this.strings.getProperty("ScheduledWorkAt"), routeLocationName));
                }
                if (!location.path("comment").textValue().isBlank()) {
                    builder.append(String.format(this.locale, this.strings.getProperty("RouteLocationComment"), location.path("comment").textValue()));
                }
                if (Setup.isPrintLocationCommentsEnabled() && !location.path("location").path("comment").textValue().isBlank()) {
                    builder.append(String.format(this.locale, this.strings.getProperty("LocationComment"), location.path("location").path("comment").textValue()));
                }
                builder.append(this.getTrackComments(location.path("track"), location.path("cars")));
            }
            previousLocationName = routeLocationName;
            if (location.path("options").size() > 0) {
                boolean changeEngines = false;
                boolean changeCaboose = false;
                for (JsonNode option : location.path("options")) {
                    switch (option.asText()) {
                        case "changeEngines": {
                            changeEngines = true;
                            break;
                        }
                        case "changeCaboose": {
                            changeCaboose = true;
                            break;
                        }
                        case "addHelpers": {
                            builder.append(String.format(this.strings.getProperty("AddHelpersAt"), routeLocationName));
                            break;
                        }
                        case "removeHelpers": {
                            builder.append(String.format(this.strings.getProperty("RemoveHelpersAt"), routeLocationName));
                            break;
                        }
                    }
                }
                if (changeEngines && changeCaboose) {
                    builder.append(String.format(this.strings.getProperty("LocoAndCabooseChangeAt"), routeLocationName));
                } else if (changeEngines) {
                    builder.append(String.format(this.strings.getProperty("LocoChangeAt"), routeLocationName));
                } else if (changeCaboose) {
                    builder.append(String.format(this.strings.getProperty("CabooseChangeAt"), routeLocationName));
                }
            }
            builder.append(this.pickupEngines(location.path("engines").path("add")));
            builder.append(this.blockCars(location.path("cars"), routeLocation, true));
            builder.append(this.dropEngines(location.path("engines").path("remove")));
            if (routeLocation != this.train.getTrainTerminatesRouteLocation()) {
                RouteLocation rlNext = this.train.getRoute().getNextRouteLocation(routeLocation);
                if (routeLocationName.equals(rlNext.getSplitName())) continue;
                if (hasWork) {
                    if (!Setup.isPrintLoadsAndEmptiesEnabled()) {
                        builder.append(String.format(this.strings.getProperty("TrainDepartsCars"), routeLocationName, this.strings.getProperty("Heading" + Setup.getDirectionString(location.path("trainDirection").intValue())), location.path("length").path("length").intValue(), location.path("length").path("unit").asText().toLowerCase(), location.path("weight").intValue(), location.path("cars").path("total").intValue()));
                        continue;
                    }
                    builder.append(String.format(this.strings.getProperty("TrainDepartsLoads"), routeLocationName, this.strings.getProperty("Heading" + Setup.getDirectionString(location.path("trainDirection").intValue())), location.path("length").path("length").intValue(), location.path("length").path("unit").asText().toLowerCase(), location.path("weight").intValue(), location.path("cars").path("loads").intValue(), location.path("cars").path("empties").intValue()));
                    continue;
                }
                log.debug("No work ({})", (Object)routeLocation.getComment());
                if (routeLocation.getComment().isBlank()) {
                    if (this.train.isShowArrivalAndDepartureTimesEnabled()) {
                        if (routeLocation == this.train.getTrainDepartsRouteLocation()) {
                            builder.append(String.format(this.locale, this.strings.getProperty("NoScheduledWorkAtWithDepartureTime"), routeLocationName, this.train.getFormatedDepartureTime()));
                        } else if (!routeLocation.getDepartureTime().isEmpty()) {
                            builder.append(String.format(this.locale, this.strings.getProperty("NoScheduledWorkAtWithDepartureTime"), routeLocationName, routeLocation.getFormatedDepartureTime()));
                        } else if (Setup.isUseDepartureTimeEnabled()) {
                            builder.append(String.format(this.locale, this.strings.getProperty("NoScheduledWorkAtWithDepartureTime"), routeLocationName, location.path("expectedDepartureTime")));
                        } else {
                            builder.append(String.format(this.locale, this.strings.getProperty("NoScheduledWorkAt"), routeLocationName));
                        }
                    } else {
                        builder.append(String.format(this.locale, this.strings.getProperty("NoScheduledWorkAt"), routeLocationName));
                    }
                } else {
                    if (!routeLocation.getComment().isBlank()) {
                        builder.append(String.format(this.locale, this.strings.getProperty("CommentAt"), routeLocationName, StringEscapeUtils.escapeHtml4((String)routeLocation.getCommentWithColor())));
                    }
                    if (this.train.isShowArrivalAndDepartureTimesEnabled()) {
                        if (routeLocation == this.train.getTrainDepartsRouteLocation()) {
                            builder.append(String.format(this.locale, this.strings.getProperty("CommentAtWithDepartureTime"), routeLocationName, this.train.getFormatedDepartureTime(), StringEscapeUtils.escapeHtml4((String)routeLocation.getComment())));
                        } else if (!routeLocation.getDepartureTime().equals("")) {
                            builder.append(String.format(this.locale, this.strings.getProperty("CommentAtWithDepartureTime"), routeLocationName, routeLocation.getFormatedDepartureTime(), StringEscapeUtils.escapeHtml4((String)routeLocation.getComment())));
                        } else if (Setup.isUseDepartureTimeEnabled() && !routeLocation.getComment().equals("")) {
                            builder.append(String.format(this.locale, this.strings.getProperty("NoScheduledWorkAtWithDepartureTime"), routeLocationName, this.train.getExpectedDepartureTime(routeLocation)));
                        }
                    }
                }
                if (!Setup.isPrintLocationCommentsEnabled() || routeLocation.getLocation().getComment().isEmpty()) continue;
                builder.append(String.format(this.locale, this.strings.getProperty("LocationComment"), StringEscapeUtils.escapeHtml4((String)routeLocation.getLocation().getCommentWithColor())));
                continue;
            }
            builder.append(String.format(this.strings.getProperty("TrainTerminatesIn"), routeLocationName));
        }
        return builder.toString();
    }

    protected String blockCars(JsonNode cars, RouteLocation location, boolean isManifest) {
        StringBuilder builder = new StringBuilder();
        log.debug("Cars is {}", (Object)cars);
        ArrayList<JsonNode> adds = new ArrayList<JsonNode>();
        cars.path("add").forEach(adds::add);
        if (adds.size() > 0 && Setup.isSortByTrackNameEnabled()) {
            adds.sort(Comparator.comparing(o -> o.path("location").path("track").path("userName").asText()));
        }
        for (JsonNode car : adds) {
            if (this.isLocalMove(car)) continue;
            if (this.isUtilityCar(car)) {
                builder.append(this.pickupUtilityCars(adds, car, location, isManifest));
                continue;
            }
            String[] messageFormat = isManifest && Setup.isPrintTruncateManifestEnabled() && location.getLocation().isSwitchListEnabled() ? Setup.getPickupTruncatedManifestMessageFormat() : Setup.getPickupManifestMessageFormat();
            Setup.stringToTagConversion(messageFormat);
            builder.append(this.pickUpCar(car, messageFormat));
        }
        ArrayList<JsonNode> drops = new ArrayList<JsonNode>();
        cars.path("remove").forEach(drops::add);
        for (JsonNode car : drops) {
            boolean local = this.isLocalMove(car);
            if (this.isUtilityCar(car)) {
                builder.append(this.setoutUtilityCars(drops, car, location, isManifest));
                continue;
            }
            if (isManifest && Setup.isPrintTruncateManifestEnabled() && location.getLocation().isSwitchListEnabled() && !this.train.isLocalSwitcher()) {
                builder.append(this.dropCar(car, Setup.getDropTruncatedManifestMessageFormat(), local));
                continue;
            }
            String[] format = isManifest ? (!local ? Setup.getDropManifestMessageFormat() : Setup.getLocalManifestMessageFormat()) : (!local ? Setup.getDropSwitchListMessageFormat() : Setup.getLocalSwitchListMessageFormat());
            Setup.stringToTagConversion(format);
            builder.append(this.dropCar(car, format, local));
        }
        return String.format(this.locale, this.strings.getProperty("CarsList"), builder.toString());
    }

    protected String pickupUtilityCars(ArrayList<JsonNode> jnCars, JsonNode jnCar, RouteLocation location, boolean isManifest) {
        List<Car> cars = this.getCarList(jnCars);
        Car car = this.getCar(jnCar);
        return this.pickupUtilityCars(cars, car, isManifest);
    }

    protected String setoutUtilityCars(ArrayList<JsonNode> jnCars, JsonNode jnCar, RouteLocation location, boolean isManifest) {
        List<Car> cars = this.getCarList(jnCars);
        Car car = this.getCar(jnCar);
        return this.setoutUtilityCars(cars, car, isManifest);
    }

    protected List<Car> getCarList(ArrayList<JsonNode> jnCars) {
        ArrayList<Car> cars = new ArrayList<Car>();
        for (JsonNode kar : jnCars) {
            cars.add(this.getCar(kar));
        }
        return cars;
    }

    protected Car getCar(JsonNode jnCar) {
        String id = jnCar.path("name").asText();
        Car car = (Car)InstanceManager.getDefault(CarManager.class).getById(id);
        return car;
    }

    protected String pickUpCar(JsonNode car, String[] format) {
        if (this.isLocalMove(car)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("<span style=\"color: " + Setup.getPickupTextColor() + ";\">");
        builder.append(Setup.getPickupCarPrefix()).append(" ");
        for (String attribute : format) {
            if (attribute.trim().isEmpty()) continue;
            attribute = attribute.toLowerCase();
            log.trace("Adding car with attribute {}", (Object)attribute);
            if (attribute.equals("location") || attribute.equals("track")) {
                attribute = "location";
                builder.append(this.getFormattedAttribute(attribute, this.getPickupLocation(car.path(attribute), HtmlTrainCommon.ShowLocation.track))).append(" ");
                continue;
            }
            if (attribute.equals("destination")) {
                builder.append(this.getFormattedAttribute(attribute, this.getDropLocation(car.path(attribute), HtmlTrainCommon.ShowLocation.location))).append(" ");
                continue;
            }
            if (attribute.equals("dest&track")) {
                builder.append(this.getFormattedAttribute(attribute, this.getDropLocation(car.path("destination"), HtmlTrainCommon.ShowLocation.both))).append(" ");
                continue;
            }
            builder.append(this.getTextAttribute(attribute, car)).append(" ");
        }
        log.debug("Picking up car {}", (Object)builder);
        return String.format(this.locale, this.strings.getProperty(this.resourcePrefix + "PickUpCar"), builder.toString());
    }

    protected String dropCar(JsonNode car, String[] format, boolean isLocal) {
        StringBuilder builder = new StringBuilder();
        if (!isLocal) {
            builder.append("<span style=\"color: " + Setup.getDropTextColor() + ";\">");
            builder.append(Setup.getDropCarPrefix()).append(" ");
        } else {
            builder.append("<span style=\"color: " + Setup.getLocalTextColor() + ";\">");
            builder.append(Setup.getLocalPrefix()).append(" ");
        }
        log.debug("dropCar {}", (Object)car);
        for (String attribute : format) {
            if (attribute.trim().isEmpty()) continue;
            attribute = attribute.toLowerCase();
            log.trace("Removing car with attribute {}", (Object)attribute);
            if (attribute.equals("destination") || attribute.equals("track")) {
                attribute = "destination";
                builder.append(this.getFormattedAttribute(attribute, this.getDropLocation(car.path(attribute), HtmlTrainCommon.ShowLocation.track))).append(" ");
                continue;
            }
            if (attribute.equals("dest&track")) {
                builder.append(this.getFormattedAttribute(attribute, this.getDropLocation(car.path("destination"), HtmlTrainCommon.ShowLocation.both))).append(" ");
                continue;
            }
            if (attribute.equals("location") && isLocal) {
                builder.append(this.getFormattedAttribute(attribute, this.getPickupLocation(car.path(attribute), HtmlTrainCommon.ShowLocation.track))).append(" ");
                continue;
            }
            if (attribute.equals("location")) {
                builder.append(this.getFormattedAttribute(attribute, this.getPickupLocation(car.path(attribute), HtmlTrainCommon.ShowLocation.location))).append(" ");
                continue;
            }
            builder.append(this.getTextAttribute(attribute, car)).append(" ");
        }
        log.debug("Dropping {}car {}", (Object)(isLocal ? "local " : ""), (Object)builder);
        if (!isLocal) {
            return String.format(this.locale, this.strings.getProperty(this.resourcePrefix + "DropCar"), builder.toString());
        }
        return String.format(this.locale, this.strings.getProperty(this.resourcePrefix + "LocalCar"), builder.toString());
    }

    protected String dropEngines(JsonNode engines) {
        StringBuilder builder = new StringBuilder();
        engines.forEach(engine -> builder.append(this.dropEngine((JsonNode)engine)));
        return String.format(this.locale, this.strings.getProperty("EnginesList"), builder.toString());
    }

    protected String dropEngine(JsonNode engine) {
        StringBuilder builder = new StringBuilder();
        builder.append("<span style=\"color: " + Setup.getDropEngineTextColor() + ";\">");
        builder.append(Setup.getDropEnginePrefix()).append(" ");
        String[] formatMessage = Setup.getDropEngineMessageFormat();
        Setup.stringToTagConversion(formatMessage);
        for (String attribute : formatMessage) {
            if (attribute.trim().isEmpty()) continue;
            if ((attribute = attribute.toLowerCase()).equals("destination") || attribute.equals("track")) {
                attribute = "destination";
                builder.append(this.getFormattedAttribute(attribute, this.getDropLocation(engine.path(attribute), HtmlTrainCommon.ShowLocation.track))).append(" ");
                continue;
            }
            if (attribute.equals("location")) {
                builder.append(this.getFormattedAttribute(attribute, this.getPickupLocation(engine.path(attribute), HtmlTrainCommon.ShowLocation.location))).append(" ");
                continue;
            }
            builder.append(this.getTextAttribute(attribute, engine)).append(" ");
        }
        log.debug("Drop engine: {}", (Object)builder);
        return String.format(this.locale, this.strings.getProperty(this.resourcePrefix + "DropEngine"), builder.toString());
    }

    protected String pickupEngines(JsonNode engines) {
        StringBuilder builder = new StringBuilder();
        if (engines.size() > 0) {
            for (JsonNode engine : engines) {
                builder.append(this.pickupEngine(engine));
            }
        }
        return String.format(this.locale, this.strings.getProperty("EnginesList"), builder.toString());
    }

    protected String pickupEngine(JsonNode engine) {
        StringBuilder builder = new StringBuilder();
        builder.append("<span style=\"color: " + Setup.getPickupEngineTextColor() + ";\">");
        builder.append(Setup.getPickupEnginePrefix()).append(" ");
        String[] messageFormat = Setup.getPickupEngineMessageFormat();
        Setup.stringToTagConversion(messageFormat);
        log.debug("PickupEngineMessageFormat: {}", (Object)messageFormat);
        for (String attribute : messageFormat) {
            if (attribute.trim().isEmpty()) continue;
            if ((attribute = attribute.toLowerCase()).equals("location") || attribute.equals("track")) {
                attribute = "location";
                builder.append(this.getFormattedAttribute(attribute, this.getPickupLocation(engine.path(attribute), HtmlTrainCommon.ShowLocation.track))).append(" ");
                continue;
            }
            if (attribute.equals("destination")) {
                builder.append(this.getFormattedAttribute(attribute, this.getDropLocation(engine.path(attribute), HtmlTrainCommon.ShowLocation.location))).append(" ");
                continue;
            }
            builder.append(this.getTextAttribute(attribute, engine)).append(" ");
        }
        log.debug("Picking up engine: {}", (Object)builder);
        return String.format(this.locale, this.strings.getProperty(this.resourcePrefix + "PickUpEngine"), builder.toString());
    }

    protected String getDropLocation(JsonNode location, HtmlTrainCommon.ShowLocation show) {
        return this.getFormattedLocation(location, show, "To");
    }

    protected String getPickupLocation(JsonNode location, HtmlTrainCommon.ShowLocation show) {
        return this.getFormattedLocation(location, show, "From");
    }

    protected String getTextAttribute(String attribute, JsonNode rollingStock) {
        if (attribute.equals("hazardous")) {
            return this.getFormattedAttribute(attribute, rollingStock.path(attribute).asBoolean() ? Setup.getHazardousMsg() : "");
        }
        if (attribute.equals("pickup msg")) {
            return this.getFormattedAttribute("pickup msg", rollingStock.path("pickup msg").textValue());
        }
        if (attribute.equals("setout msg")) {
            return this.getFormattedAttribute("setout msg", rollingStock.path("setout msg").textValue());
        }
        if (attribute.equals("rwe")) {
            return this.getFormattedLocation(rollingStock.path("rwe"), HtmlTrainCommon.ShowLocation.both, "RWE");
        }
        if (attribute.equals("final dest")) {
            return this.getFormattedLocation(rollingStock.path("final dest"), HtmlTrainCommon.ShowLocation.location, "FinalDestination");
        }
        if (attribute.equals("fd&track")) {
            return this.getFormattedLocation(rollingStock.path("final dest"), HtmlTrainCommon.ShowLocation.both, "FinalDestination");
        }
        if (attribute.equals("last train")) {
            return TrainManifestHeaderText.getStringHeader_Last_Train() + " " + this.getFormattedAttribute(attribute, rollingStock.path(attribute).asText());
        }
        return this.getFormattedAttribute(attribute, rollingStock.path(attribute).asText());
    }

    protected String getFormattedAttribute(String attribute, String value) {
        return String.format(this.locale, this.strings.getProperty("Attribute"), StringEscapeUtils.escapeHtml4((String)value), attribute);
    }

    protected String getFormattedLocation(JsonNode location, HtmlTrainCommon.ShowLocation show, String prefix) {
        if (location.isNull() || location.isEmpty()) {
            return "";
        }
        switch (show) {
            case location: {
                return String.format(this.locale, this.strings.getProperty(prefix + "Location"), HtmlManifest.splitString(location.path("userName").asText()));
            }
            case track: {
                return String.format(this.locale, this.strings.getProperty(prefix + "Track"), HtmlManifest.splitString(location.path("track").path("userName").asText()));
            }
        }
        return String.format(this.locale, this.strings.getProperty(prefix + "LocationAndTrack"), HtmlManifest.splitString(location.path("userName").asText()), HtmlManifest.splitString(location.path("track").path("userName").asText()));
    }

    private String getTrackComments(JsonNode tracks, JsonNode cars) {
        StringBuilder builder = new StringBuilder();
        if (tracks.size() > 0) {
            Iterator iterator = tracks.fields();
            while (iterator.hasNext()) {
                Map.Entry track = (Map.Entry)iterator.next();
                boolean pickup = false;
                boolean setout = false;
                if (cars.path("add").size() > 0) {
                    for (JsonNode car : cars.path("add")) {
                        if (!((String)track.getKey()).equals(car.path("location").path("track").path("name").asText())) continue;
                        pickup = true;
                        break;
                    }
                }
                if (cars.path("remove").size() > 0) {
                    for (JsonNode car : cars.path("remove")) {
                        if (!((String)track.getKey()).equals(car.path("destination").path("track").path("name").textValue())) continue;
                        setout = true;
                        break;
                    }
                }
                if (pickup && setout) {
                    builder.append(String.format(this.locale, this.strings.getProperty("TrackComments"), ((JsonNode)track.getValue()).path("addAndRemove").textValue()));
                    continue;
                }
                if (pickup) {
                    builder.append(String.format(this.locale, this.strings.getProperty("TrackComments"), ((JsonNode)track.getValue()).path("add").textValue()));
                    continue;
                }
                if (!setout) continue;
                builder.append(String.format(this.locale, this.strings.getProperty("TrackComments"), ((JsonNode)track.getValue()).path("remove").textValue()));
            }
        }
        return builder.toString();
    }

    protected boolean isLocalMove(JsonNode car) {
        return car.path("isLocal").booleanValue();
    }

    protected boolean isUtilityCar(JsonNode car) {
        return car.path("utility").booleanValue();
    }

    protected JsonNode getJsonManifest() throws IOException {
        if (this.jsonManifest == null) {
            try {
                this.jsonManifest = this.mapper.readTree(new JsonManifest(this.train).getFile());
            }
            catch (IOException e) {
                log.error("Json manifest file not found for train ({})", (Object)this.train.getName());
            }
        }
        return this.jsonManifest;
    }

    @Override
    public String getValidity() {
        try {
            if (Setup.isPrintTrainScheduleNameEnabled()) {
                return String.format(this.locale, this.strings.getProperty(this.resourcePrefix + "ValidityWithSchedule"), HtmlManifest.getDate(new StdDateFormat().parse(this.getJsonManifest().path("date").textValue())), InstanceManager.getDefault(TrainScheduleManager.class).getActiveSchedule().getName());
            }
            return String.format(this.locale, this.strings.getProperty(this.resourcePrefix + "Validity"), HtmlManifest.getDate(new StdDateFormat().parse(this.getJsonManifest().path("date").textValue())));
        }
        catch (NullPointerException ex) {
            log.warn("Manifest for train {} (id {}) does not have any validity.", (Object)this.train.getIconName(), (Object)this.train.getId());
        }
        catch (ParseException ex) {
            log.error("Date of JSON manifest could not be parsed as a Date.");
        }
        catch (IOException ex) {
            log.error("JSON manifest could not be read.");
        }
        return "";
    }
}

