/*
 * Decompiled with CFR 0.152.
 */
package jmri.web.servlet.operations;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Reader;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsManager;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.JsonManifest;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.server.json.operations.JsonUtil;
import jmri.util.FileUtil;
import jmri.web.server.WebServer;
import jmri.web.servlet.ServletUtil;
import jmri.web.servlet.operations.Bundle;
import jmri.web.servlet.operations.HtmlConductor;
import jmri.web.servlet.operations.HtmlManifest;
import jmri.web.servlet.operations.HtmlTrainCommon;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="OperationsServlet", urlPatterns={"/operations", "/web/operationsConductor.html", "/web/operationsManifest.html", "/web/operationsTrains.html"})
public class OperationsServlet
extends HttpServlet {
    private ObjectMapper mapper;
    private static final Logger log = LoggerFactory.getLogger(OperationsServlet.class);

    public void init() throws ServletException {
        if (this.getServletContext().getContextPath().equals("/operations")) {
            this.mapper = new ObjectMapper();
            InstanceManager.getDefault(OperationsManager.class);
        }
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getRequestURI().equals("/web/operationsConductor.html") || request.getRequestURI().equals("/web/operationsManifest.html") || request.getRequestURI().equals("/web/operationsTrains.html")) {
            response.sendRedirect("/operations");
            return;
        }
        String[] pathInfo = request.getPathInfo().substring(1).split("/");
        response.setHeader("Connection", "Keep-Alive");
        if (pathInfo[0].equals("") || pathInfo[0].equals("trains") && pathInfo.length == 1) {
            this.processTrains(request, response);
        } else if (pathInfo.length == 1) {
            response.sendError(400);
        } else {
            String id = pathInfo[1];
            String report = pathInfo[0];
            if (report.equals("trains") && pathInfo.length == 3) {
                report = pathInfo[2];
            }
            log.debug("Handling {} with id {}", (Object)report, (Object)id);
            switch (report) {
                case "manifest": {
                    this.processManifest(id, request, response);
                    break;
                }
                case "conductor": {
                    this.processConductor(id, request, response);
                    break;
                }
                case "trains": {
                    log.warn("Unhandled request for \"trains\"");
                    response.sendError(400);
                    break;
                }
                default: {
                    log.warn("Unparsed request for \"{}\"", (Object)report);
                    response.sendError(400);
                }
            }
        }
    }

    protected void processTrains(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if ("json".equals(request.getParameter("format"))) {
            response.setContentType("application/json; charset=utf-8");
            InstanceManager.getDefault(ServletUtil.class).setNonCachingHeaders(response);
            JsonUtil utilities = new JsonUtil(this.mapper);
            response.getWriter().print(utilities.getTrains(request.getLocale()));
        } else if ("html".equals(request.getParameter("format"))) {
            response.setContentType("text/html; charset=utf-8");
            InstanceManager.getDefault(ServletUtil.class).setNonCachingHeaders(response);
            boolean showAll = "all".equals(request.getParameter("show"));
            StringBuilder html = new StringBuilder();
            String format = FileUtil.readURL(FileUtil.findURL(Bundle.getMessage(request.getLocale(), "TrainsSnippet.html")));
            for (Train train : InstanceManager.getDefault(TrainManager.class).getTrainsByNameList()) {
                if (!showAll && InstanceManager.getDefault(CarManager.class).getByTrainDestinationList(train).isEmpty()) continue;
                html.append(String.format(request.getLocale(), format, train.getIconName(), StringEscapeUtils.escapeHtml4((String)train.getDescription()), train.getLeadEngine() != null ? train.getLeadEngine().toString() : "", StringEscapeUtils.escapeHtml4((String)train.getTrainDepartsName()), train.getDepartureTime(), train.getStatus(), StringEscapeUtils.escapeHtml4((String)train.getCurrentLocationName()), StringEscapeUtils.escapeHtml4((String)train.getTrainTerminatesName()), StringEscapeUtils.escapeHtml4((String)train.getTrainRouteName()), train.getId()));
            }
            response.getWriter().print(html.toString());
        } else {
            response.setContentType("text/html; charset=utf-8");
            response.getWriter().print(String.format(request.getLocale(), FileUtil.readURL(FileUtil.findURL(Bundle.getMessage(request.getLocale(), "Operations.html"))), String.format(request.getLocale(), Bundle.getMessage(request.getLocale(), "HtmlTitle"), InstanceManager.getDefault(ServletUtil.class).getRailroadName(false), Bundle.getMessage(request.getLocale(), "TrainsTitle")), InstanceManager.getDefault(ServletUtil.class).getNavBar(request.getLocale(), request.getContextPath()), InstanceManager.getDefault(ServletUtil.class).getRailroadName(false), InstanceManager.getDefault(ServletUtil.class).getFooter(request.getLocale(), request.getContextPath()), ""));
        }
    }

    private void processManifest(String id, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Train train = InstanceManager.getDefault(TrainManager.class).getTrainById(id);
        if ("html".equals(request.getParameter("format"))) {
            log.debug("Getting manifest HTML code for train {}", (Object)id);
            HtmlManifest manifest = new HtmlManifest(request.getLocale(), train);
            InstanceManager.getDefault(ServletUtil.class).setNonCachingHeaders(response);
            response.setContentType("text/html; charset=utf-8");
            response.getWriter().print(String.format(request.getLocale(), FileUtil.readURL(FileUtil.findURL(Bundle.getMessage(request.getLocale(), "ManifestSnippet.html"))), train.getIconName(), StringEscapeUtils.escapeHtml4((String)train.getDescription()), Setup.isPrintValidEnabled() ? manifest.getValidity() : "", HtmlTrainCommon.convertToHTMLColor(StringEscapeUtils.escapeHtml4((String)train.getCommentWithColor())), Setup.isPrintRouteCommentsEnabled() ? train.getRoute().getComment() : "", HtmlTrainCommon.convertToHTMLColor(manifest.getLocations())));
        } else if ("json".equals(request.getParameter("format"))) {
            log.debug("Getting manifest JSON code for train {}", (Object)id);
            JsonNode manifest = this.mapper.readTree(new JsonManifest(train).getFile());
            if (manifest.path("image").isTextual()) {
                ((ObjectNode)manifest).put("image", WebServer.portablePathToURI(FileUtil.getPortableFilename(manifest.path("image").asText())));
            }
            String content = this.mapper.writeValueAsString((Object)manifest);
            response.setContentType("application/json; charset=utf-8");
            response.setContentLength(content.getBytes(ServletUtil.UTF8).length);
            response.getWriter().print(content);
        } else {
            response.setContentType("text/html; charset=utf-8");
            response.getWriter().print(String.format(request.getLocale(), FileUtil.readURL(FileUtil.findURL(Bundle.getMessage(request.getLocale(), "Operations.html"))), String.format(request.getLocale(), Bundle.getMessage(request.getLocale(), "HtmlTitle"), InstanceManager.getDefault(ServletUtil.class).getRailroadName(false), String.format(request.getLocale(), Bundle.getMessage(request.getLocale(), "ManifestTitle"), train.getIconName(), StringEscapeUtils.escapeHtml4((String)train.getDescription()))), InstanceManager.getDefault(ServletUtil.class).getNavBar(request.getLocale(), request.getContextPath()), !train.getRailroadName().equals("") ? train.getRailroadName() : InstanceManager.getDefault(ServletUtil.class).getRailroadName(false), InstanceManager.getDefault(ServletUtil.class).getFooter(request.getLocale(), request.getContextPath()), train.getId()));
        }
    }

    private void processConductor(String id, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ObjectNode data;
        Train train = InstanceManager.getDefault(TrainManager.class).getTrainById(id);
        if (request.getContentType() != null && request.getContentType().contains("application/json")) {
            data = this.mapper.readTree((Reader)request.getReader());
            if (!data.path("data").isMissingNode()) {
                data = data.path("data");
            }
        } else {
            data = this.mapper.createObjectNode();
            data.put("format", request.getParameter("format"));
        }
        if (data.path("format").asText().equals("html")) {
            JsonNode location = data.path("location");
            if (!location.isMissingNode() && (location.isNull() || train.getNextLocationName().equals(location.asText()))) {
                train.move();
                return;
            }
            log.debug("Getting conductor HTML code for train {}", (Object)id);
            HtmlConductor conductor = new HtmlConductor(request.getLocale(), train);
            InstanceManager.getDefault(ServletUtil.class).setNonCachingHeaders(response);
            response.setContentType("text/html; charset=utf-8");
            response.getWriter().print(conductor.getLocation());
        } else {
            response.setContentType("text/html; charset=utf-8");
            response.getWriter().print(String.format(request.getLocale(), FileUtil.readURL(FileUtil.findURL(Bundle.getMessage(request.getLocale(), "Operations.html"))), String.format(request.getLocale(), Bundle.getMessage(request.getLocale(), "HtmlTitle"), InstanceManager.getDefault(ServletUtil.class).getRailroadName(false), String.format(request.getLocale(), Bundle.getMessage(request.getLocale(), "ConductorTitle"), train.getIconName(), StringEscapeUtils.escapeHtml4((String)train.getDescription()))), InstanceManager.getDefault(ServletUtil.class).getNavBar(request.getLocale(), request.getContextPath()), !train.getRailroadName().equals("") ? train.getRailroadName() : InstanceManager.getDefault(ServletUtil.class).getRailroadName(false), InstanceManager.getDefault(ServletUtil.class).getFooter(request.getLocale(), request.getContextPath()), train.getId()));
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Operations Servlet";
    }
}

