/*
 * Decompiled with CFR 0.152.
 */
package jmri.web.servlet.panel;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.JComponent;
import javax.swing.JFrame;
import jmri.InstanceManager;
import jmri.PermissionManager;
import jmri.Sensor;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.configurexml.ConfigXmlManager;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.EditorManager;
import jmri.jmrit.display.EditorPermissions;
import jmri.jmrit.display.MultiSensorIcon;
import jmri.jmrit.display.Positionable;
import jmri.server.json.util.JsonUtilHttpService;
import jmri.util.FileUtil;
import jmri.web.server.WebServer;
import jmri.web.servlet.ServletUtil;
import jmri.web.servlet.panel.Bundle;
import jmri.web.servlet.permission.PermissionServlet;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPanelServlet
extends HttpServlet {
    protected ObjectMapper mapper;
    private static final Logger log = LoggerFactory.getLogger(AbstractPanelServlet.class);

    protected abstract String getPanelType();

    public void init() throws ServletException {
        if (!this.getServletContext().getContextPath().equals("/web/showPanel.html")) {
            this.mapper = new ObjectMapper();
            this.mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug("Handling GET request for {}", (Object)request.getRequestURI());
        String sessionId = PermissionServlet.getSessionId(request);
        if (!InstanceManager.getDefault(PermissionManager.class).hasAtLeastRemotePermission(sessionId, EditorPermissions.EDITOR_PERMISSION, EditorPermissions.EditorPermissionEnum.View)) {
            PermissionServlet.permissionDenied(request, response);
            return;
        }
        if (request.getRequestURI().equals("/web/showPanel.html")) {
            response.sendRedirect("/panel/");
            return;
        }
        if (request.getParameter("name") != null) {
            String panelName = URLDecoder.decode(request.getParameter("name"), ServletUtil.UTF8);
            if (this.getEditor(panelName) != null) {
                response.sendRedirect("/panel/" + URLEncoder.encode(panelName, ServletUtil.UTF8));
            } else {
                response.sendRedirect("/panel/");
            }
        } else if (request.getRequestURI().endsWith("/")) {
            this.listPanels(request, response);
        } else {
            String[] path = request.getRequestURI().split("/");
            String panelName = URLDecoder.decode(path[path.length - 1], ServletUtil.UTF8);
            String format = request.getParameter("format");
            if (format == null) {
                this.listPanels(request, response);
            } else {
                switch (format) {
                    case "png": {
                        BufferedImage image = this.getPanelImage(panelName);
                        if (image == null) {
                            response.sendError(500, "See the JMRI console for details.");
                            break;
                        }
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        ImageIO.write((RenderedImage)image, "png", baos);
                        baos.close();
                        response.setContentType("image/png");
                        response.setStatus(200);
                        response.setContentLength(baos.size());
                        response.getOutputStream().write(baos.toByteArray());
                        response.getOutputStream().close();
                        break;
                    }
                    case "html": {
                        this.listPanels(request, response);
                        break;
                    }
                    default: {
                        boolean useXML = !"json".equals(request.getParameter("format"));
                        response.setContentType("application/json; charset=utf-8");
                        String panel = this.getPanelText(panelName, useXML);
                        if (panel == null) {
                            response.sendError(500, "See the JMRI console for details.");
                            break;
                        }
                        if (panel.startsWith("ERROR")) {
                            response.sendError(500, panel.substring(5).trim());
                            break;
                        }
                        response.setStatus(200);
                        response.setContentLength(panel.getBytes(ServletUtil.UTF8).length);
                        response.getOutputStream().print(panel);
                        break;
                    }
                }
            }
        }
    }

    protected void listPanels(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if ("json".equals(request.getParameter("format"))) {
            response.setContentType("application/json; charset=utf-8");
            InstanceManager.getDefault(ServletUtil.class).setNonCachingHeaders(response);
            JsonUtilHttpService service = new JsonUtilHttpService(new ObjectMapper());
            response.getWriter().print(service.getPanels("xml", 0));
        } else {
            response.setContentType("text/html; charset=utf-8");
            response.getWriter().print(String.format(request.getLocale(), FileUtil.readURL(FileUtil.findURL(Bundle.getMessage(request.getLocale(), "Panel.html"))), String.format(request.getLocale(), Bundle.getMessage(request.getLocale(), "HtmlTitle"), InstanceManager.getDefault(ServletUtil.class).getRailroadName(false), Bundle.getMessage(request.getLocale(), "PanelsTitle")), InstanceManager.getDefault(ServletUtil.class).getNavBar(request.getLocale(), "/panel"), InstanceManager.getDefault(ServletUtil.class).getRailroadName(false), InstanceManager.getDefault(ServletUtil.class).getFooter(request.getLocale(), "/panel")));
        }
    }

    protected BufferedImage getPanelImage(String name) {
        JComponent panel = this.getPanel(name);
        if (panel == null) {
            return null;
        }
        BufferedImage bi = new BufferedImage(panel.getWidth(), panel.getHeight(), 2);
        panel.paint(bi.getGraphics());
        return bi;
    }

    @CheckForNull
    protected JComponent getPanel(String name) {
        Editor editor = this.getEditor(name);
        if (editor != null) {
            return editor.getTargetPanel();
        }
        return null;
    }

    protected String getPanelText(String name, boolean useXML) {
        if (useXML) {
            return this.getXmlPanel(name);
        }
        return this.getJsonPanel(name);
    }

    protected abstract String getJsonPanel(String var1);

    protected abstract String getXmlPanel(String var1);

    @CheckForNull
    protected Editor getEditor(String name) {
        for (Editor editor : InstanceManager.getDefault(EditorManager.class).getAll()) {
            JFrame frame = editor.getTargetFrame();
            if (!frame.getTitle().equals(name)) continue;
            return editor;
        }
        return null;
    }

    protected void parsePortableURIs(Element element) {
        if (element != null) {
            element.getAttributes().forEach(attr -> {
                String url;
                String value = attr.getValue();
                if (FileUtil.isPortableFilename(value) && (url = WebServer.portablePathToURI(value)) != null) {
                    attr.setValue(url);
                }
            });
            element.getChildren().forEach(child -> this.parsePortableURIs((Element)child));
        }
    }

    protected Element getSignalMastIconsElement(String name, String imageset) {
        Element icons = new Element("icons");
        SignalMast signalMast = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(name);
        if (signalMast != null) {
            Element ea;
            String imgset = imageset == null ? "default" : imageset;
            signalMast.getValidAspects().forEach(aspect -> {
                Element ea = new Element(aspect.replaceAll("[ ()]", ""));
                Object url = signalMast.getAppearanceMap().getImageLink((String)aspect, imgset);
                if (!((String)url).contains("preference:")) {
                    url = "/" + ((String)url).substring(((String)url).indexOf("resources"));
                }
                ea.setAttribute("aspect", aspect);
                ea.setAttribute("url", (String)url);
                icons.addContent((Content)ea);
            });
            Object url = signalMast.getAppearanceMap().getImageLink("$held", imgset);
            if (!((String)url).isEmpty()) {
                if (!((String)url).contains("preference:")) {
                    url = "/" + ((String)url).substring(((String)url).indexOf("resources"));
                }
                ea = new Element("Held");
                ea.setAttribute("aspect", "Held");
                ea.setAttribute("url", (String)url);
                icons.addContent((Content)ea);
            }
            if (!((String)(url = signalMast.getAppearanceMap().getImageLink("$dark", imgset))).isEmpty()) {
                if (!((String)url).contains("preference:")) {
                    url = "/" + ((String)url).substring(((String)url).indexOf("resources"));
                }
                ea = new Element("Dark");
                ea.setAttribute("aspect", "Dark");
                ea.setAttribute("url", (String)url);
                icons.addContent((Content)ea);
            }
            ea = new Element("Unknown");
            ea.setAttribute("aspect", "Unknown");
            ea.setAttribute("url", "/resources/icons/misc/X-red.gif");
            icons.addContent((Content)ea);
        }
        return icons;
    }

    protected Element positionableElement(@Nonnull Positionable sub) {
        Element e = ConfigXmlManager.elementFromObject(sub);
        if (e != null) {
            switch (e.getName()) {
                case "signalmasticon": {
                    e.addContent((Content)this.getSignalMastIconsElement(e.getAttributeValue("signalmast"), e.getAttributeValue("imageset")));
                    break;
                }
                case "multisensoricon": {
                    if (!(sub instanceof MultiSensorIcon)) break;
                    List<Sensor> sensors = ((MultiSensorIcon)sub).getSensors();
                    for (Element a : e.getChildren()) {
                        String s = a.getAttributeValue("sensor");
                        if (s == null) continue;
                        for (Sensor sensor : sensors) {
                            if (!s.equals(sensor.getUserName())) continue;
                            a.setAttribute("sensor", sensor.getSystemName());
                        }
                    }
                    break;
                }
            }
            if (sub.getNamedBean() != null) {
                try {
                    e.setAttribute("id", sub.getNamedBean().getSystemName());
                }
                catch (NullPointerException ex) {
                    if (sub.getNamedBean() == null) {
                        log.debug("{} {} does not have an associated NamedBean", (Object)e.getName(), (Object)e.getAttribute("name"));
                    }
                    log.debug("{} {} does not have a SystemName", (Object)e.getName(), (Object)e.getAttribute("name"));
                }
            }
            this.parsePortableURIs(e);
        }
        return e;
    }
}

