/*
 * Decompiled with CFR 0.152.
 */
package jmri.web.servlet.panel;

import java.util.List;
import javax.servlet.annotation.WebServlet;
import javax.swing.JFrame;
import jmri.jmrit.display.IndicatorTrackIcon;
import jmri.jmrit.display.IndicatorTurnoutIcon;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.controlPanelEditor.ControlPanelEditor;
import jmri.web.servlet.panel.AbstractPanelServlet;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="ControlPanelServlet", urlPatterns={"/panel/ControlPanel"})
public class ControlPanelServlet
extends AbstractPanelServlet {
    private static final Logger log = LoggerFactory.getLogger(ControlPanelServlet.class);

    @Override
    protected String getPanelType() {
        return "ControlPanel";
    }

    @Override
    protected String getXmlPanel(String name) {
        log.debug("Getting {} for {}", (Object)this.getPanelType(), (Object)name);
        ControlPanelEditor editor = (ControlPanelEditor)this.getEditor(name);
        if (editor == null) {
            log.warn("Requested ControlPanel [{}] does not exist.", (Object)name);
            return "ERROR Requested panel [" + name + "] does not exist.";
        }
        Element panel = new Element("panel");
        JFrame frame = editor.getTargetFrame();
        panel.setAttribute("name", name);
        panel.setAttribute("height", Integer.toString(frame.getContentPane().getHeight()));
        panel.setAttribute("width", Integer.toString(frame.getContentPane().getWidth()));
        panel.setAttribute("panelheight", Integer.toString(editor.getTargetPanel().getHeight()));
        panel.setAttribute("panelwidth", Integer.toString(editor.getTargetPanel().getWidth()));
        panel.setAttribute("showtooltips", editor.showToolTip() ? "yes" : "no");
        panel.setAttribute("controlling", editor.allControlling() ? "yes" : "no");
        if (editor.getBackgroundColor() != null) {
            Element color = new Element("backgroundColor");
            color.setAttribute("red", Integer.toString(editor.getBackgroundColor().getRed()));
            color.setAttribute("green", Integer.toString(editor.getBackgroundColor().getGreen()));
            color.setAttribute("blue", Integer.toString(editor.getBackgroundColor().getBlue()));
            panel.addContent((Content)color);
        }
        List<Positionable> contents = editor.getContents();
        log.debug("N elements: {}", (Object)contents.size());
        for (Positionable sub : contents) {
            if (sub == null) continue;
            Element e = new Element("temp");
            try {
                e = this.positionableElement(sub);
            }
            catch (Exception ex) {
                log.error("Error storing panel element: {}", (Object)ex, (Object)ex);
            }
            switch (e.getName()) {
                case "indicatorturnouticon": {
                    Element elem = new Element("oblocksysname");
                    if (((IndicatorTurnoutIcon)sub).getOccBlock() != null) {
                        String itoioblock = ((IndicatorTurnoutIcon)sub).getOccBlock().getSystemName();
                        elem.addContent(itoioblock);
                        log.debug("CP-SERVLET ITOI = {}", (Object)itoioblock);
                    } else {
                        elem.addContent("none");
                        log.debug("no oblocksensor configured on ITOI {}", (Object)sub.getNameString());
                    }
                    e.addContent((Content)elem);
                    break;
                }
                case "indicatortrackicon": {
                    Element elem = new Element("oblocksysname");
                    if (((IndicatorTrackIcon)sub).getOccBlock() != null) {
                        String itioblock = ((IndicatorTrackIcon)sub).getOccBlock().getSystemName();
                        elem.addContent(itioblock);
                        log.debug("CP-SERVLET ITI = {}", (Object)itioblock);
                    } else {
                        elem.addContent("none");
                        log.debug("no oblocksensor configured on ITI {}", (Object)sub.getNameString());
                    }
                    e.addContent((Content)elem);
                    break;
                }
            }
            panel.addContent((Content)e);
        }
        Document doc = new Document(panel);
        XMLOutputter out = new XMLOutputter();
        out.setFormat(Format.getPrettyFormat().setLineSeparator(System.getProperty("line.separator")).setTextMode(Format.TextMode.TRIM));
        return out.outputString(doc);
    }

    @Override
    protected String getJsonPanel(String name) {
        return "ERROR JSON support not implemented";
    }
}

