/*
 * Decompiled with CFR 0.152.
 */
package jmri.web.servlet.panel;

import java.awt.Color;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.servlet.annotation.WebServlet;
import jmri.InstanceManager;
import jmri.Memory;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.configurexml.ConfigXmlManager;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutShape;
import jmri.jmrit.display.layoutEditor.LayoutTrackDrawingOptions;
import jmri.jmrit.display.layoutEditor.LayoutTrackView;
import jmri.jmrit.display.layoutEditor.LayoutTurntable;
import jmri.jmrit.display.layoutEditor.TrackSegmentView;
import jmri.util.ColorUtil;
import jmri.web.servlet.panel.AbstractPanelServlet;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="LayoutPanelServlet", urlPatterns={"/panel/Layout"})
public class LayoutPanelServlet
extends AbstractPanelServlet {
    private static final Logger log = LoggerFactory.getLogger(LayoutPanelServlet.class);

    @Override
    protected String getPanelType() {
        return "LayoutPanel";
    }

    @Override
    protected String getXmlPanel(String name) {
        log.debug("Getting {} for {}", (Object)this.getPanelType(), (Object)name);
        LayoutEditor editor = (LayoutEditor)this.getEditor(name);
        if (editor == null) {
            log.warn("Requested LayoutPanel [{}] does not exist.", (Object)name);
            return "ERROR Requested panel [" + name + "] does not exist.";
        }
        Element panel = new Element("panel");
        panel.setAttribute("name", name);
        panel.setAttribute("paneltype", this.getPanelType());
        panel.setAttribute("height", Integer.toString(editor.gContext.getLayoutHeight()));
        panel.setAttribute("width", Integer.toString(editor.gContext.getLayoutWidth()));
        panel.setAttribute("panelheight", Integer.toString(editor.gContext.getLayoutHeight()));
        panel.setAttribute("panelwidth", Integer.toString(editor.gContext.getLayoutWidth()));
        panel.setAttribute("showtooltips", editor.showToolTip() ? "yes" : "no");
        panel.setAttribute("controlling", editor.allControlling() ? "yes" : "no");
        panel.setAttribute("xscale", Float.toString((float)editor.gContext.getXScale()));
        panel.setAttribute("yscale", Float.toString((float)editor.gContext.getYScale()));
        panel.setAttribute("mainlinetrackwidth", Integer.toString(editor.gContext.getMainlineTrackWidth()));
        panel.setAttribute("sidelinetrackwidth", Integer.toString(editor.gContext.getSidelineTrackWidth()));
        panel.setAttribute("mainlineblockwidth", Integer.toString(editor.gContext.getMainlineBlockWidth()));
        panel.setAttribute("sidelineblockwidth", Integer.toString(editor.gContext.getSidelineBlockWidth()));
        panel.setAttribute("turnoutcircles", editor.getTurnoutCircles() ? "yes" : "no");
        panel.setAttribute("turnoutcirclesize", Integer.toString(editor.getTurnoutCircleSize()));
        panel.setAttribute("turnoutdrawunselectedleg", editor.isTurnoutDrawUnselectedLeg() ? "yes" : "no");
        if (editor.getBackgroundColor() == null) {
            panel.setAttribute("backgroundcolor", ColorUtil.colorToColorName(Color.lightGray));
        } else {
            panel.setAttribute("backgroundcolor", ColorUtil.colorToColorName(editor.getBackgroundColor()));
        }
        panel.setAttribute("defaulttrackcolor", editor.getDefaultTrackColor());
        panel.setAttribute("defaultoccupiedtrackcolor", editor.getDefaultOccupiedTrackColor());
        panel.setAttribute("defaultalternativetrackcolor", editor.getDefaultAlternativeTrackColor());
        panel.setAttribute("defaulttextcolor", editor.getDefaultTextColor());
        panel.setAttribute("turnoutcirclecolor", editor.getTurnoutCircleColor());
        panel.setAttribute("turnoutcirclethrowncolor", editor.getTurnoutCircleThrownColor());
        panel.setAttribute("turnoutfillcontrolcircles", editor.isTurnoutFillControlCircles() ? "yes" : "no");
        LayoutTrackDrawingOptions ltdo = editor.getLayoutTrackDrawingOptions();
        panel.setAttribute("mainBallastColor", ColorUtil.colorToColorName(ltdo.getMainBallastColor()));
        panel.setAttribute("mainBallastWidth", Integer.toString(ltdo.getMainBallastWidth()));
        panel.setAttribute("mainBlockLineDashPercentageX10", Integer.toString(ltdo.getMainBlockLineDashPercentageX10()));
        panel.setAttribute("mainBlockLineWidth", Integer.toString(ltdo.getMainBlockLineWidth()));
        panel.setAttribute("mainRailColor", ColorUtil.colorToColorName(ltdo.getMainRailColor()));
        panel.setAttribute("mainRailCount", Integer.toString(ltdo.getMainRailCount()));
        panel.setAttribute("mainRailGap", Integer.toString(ltdo.getMainRailGap()));
        panel.setAttribute("mainRailWidth", Integer.toString(ltdo.getMainRailWidth()));
        panel.setAttribute("mainTieColor", ColorUtil.colorToColorName(ltdo.getMainTieColor()));
        panel.setAttribute("mainTieGap", Integer.toString(ltdo.getMainTieGap()));
        panel.setAttribute("mainTieLength", Integer.toString(ltdo.getMainTieLength()));
        panel.setAttribute("mainTieWidth", Integer.toString(ltdo.getMainTieWidth()));
        panel.setAttribute("sideBallastColor", ColorUtil.colorToColorName(ltdo.getSideBallastColor()));
        panel.setAttribute("sideBallastWidth", Integer.toString(ltdo.getSideBallastWidth()));
        panel.setAttribute("sideBlockLineDashPercentageX10", Integer.toString(ltdo.getSideBlockLineDashPercentageX10()));
        panel.setAttribute("sideBlockLineWidth", Integer.toString(ltdo.getSideBlockLineWidth()));
        panel.setAttribute("sideRailColor", ColorUtil.colorToColorName(ltdo.getSideRailColor()));
        panel.setAttribute("sideRailCount", Integer.toString(ltdo.getSideRailCount()));
        panel.setAttribute("sideRailGap", Integer.toString(ltdo.getSideRailGap()));
        panel.setAttribute("sideRailWidth", Integer.toString(ltdo.getSideRailWidth()));
        panel.setAttribute("sideTieColor", ColorUtil.colorToColorName(ltdo.getSideTieColor()));
        panel.setAttribute("sideTieGap", Integer.toString(ltdo.getSideTieGap()));
        panel.setAttribute("sideTieLength", Integer.toString(ltdo.getSideTieLength()));
        panel.setAttribute("sideTieWidth", Integer.toString(ltdo.getSideTieWidth()));
        List<Positionable> contents = editor.getContents();
        log.debug("Number of positionable elements: {}", (Object)contents.size());
        for (Positionable sub : contents) {
            if (sub == null) continue;
            try {
                panel.addContent((Content)this.positionableElement(sub));
            }
            catch (Exception ex) {
                log.error("Error storing panel positionable element", (Throwable)ex);
            }
        }
        LayoutBlockManager lbm = InstanceManager.getDefault(LayoutBlockManager.class);
        Iterator iter = lbm.getNamedBeanSet().iterator();
        SensorManager sm = InstanceManager.sensorManagerInstance();
        int num = 0;
        while (iter.hasNext()) {
            Sensor sensor;
            LayoutBlock b = (LayoutBlock)iter.next();
            if (b == null) {
                log.error("LayoutBlock null during LayoutBlock store");
                continue;
            }
            if (b.getUseCount() <= 0) continue;
            Element elem = new Element("layoutblock").setAttribute("systemName", b.getSystemName());
            String uname = b.getUserName();
            if (uname != null && !uname.isEmpty()) {
                elem.setAttribute("username", uname);
            }
            if (!b.getOccupancySensorName().isEmpty()) {
                Sensor sensor2 = sm.getSensor(b.getOccupancySensorName());
                if (sensor2 != null) {
                    elem.setAttribute("occupancysensor", sensor2.getSystemName());
                }
            } else if (b.getBlock() != null && (sensor = b.getBlock().getSensor()) != null) {
                elem.setAttribute("occupancysensor", sensor.getSystemName());
            }
            elem.setAttribute("occupiedsense", Integer.toString(b.getOccupiedSense()));
            elem.setAttribute("trackcolor", ColorUtil.colorToColorName(b.getBlockTrackColor()));
            elem.setAttribute("occupiedcolor", ColorUtil.colorToColorName(b.getBlockOccupiedColor()));
            elem.setAttribute("extracolor", ColorUtil.colorToColorName(b.getBlockExtraColor()));
            Memory memory = b.getMemory();
            if (!b.getMemoryName().isEmpty() && memory != null) {
                elem.setAttribute("memory", memory.getSystemName());
            }
            if (!b.useDefaultMetric()) {
                elem.addContent((Content)new Element("metric").addContent(Integer.toString(b.getBlockMetric())));
            }
            panel.addContent((Content)elem);
            ++num;
        }
        log.debug("Number of layoutblock elements: {}", (Object)num);
        List<LayoutTrackView> layoutTrackViews = editor.getLayoutTrackViews();
        log.debug("Number of LayoutTrack elements: {}", (Object)layoutTrackViews.size());
        for (int pass = 0; pass < 2; ++pass) {
            for (LayoutShape layoutShape : layoutTrackViews) {
                boolean isTSV = layoutShape instanceof TrackSegmentView;
                if (pass != (isTSV ? 1 : 0)) continue;
                try {
                    Element e = ConfigXmlManager.elementFromObject(layoutShape);
                    if (e == null) continue;
                    this.replaceUserNames(e);
                    if (layoutShape instanceof LayoutTurntable) {
                        List raytracks = e.getChildren("raytrack");
                        for (Element raytrack : raytracks) {
                            this.replaceUserNameAttribute(raytrack, "turnout", "turnout");
                        }
                    }
                    panel.addContent((Content)e);
                }
                catch (Exception e) {
                    log.error("Error storing panel LayoutTrack element", (Throwable)e);
                }
            }
        }
        List<LayoutShape> layoutShapes = editor.getLayoutShapes();
        for (LayoutShape layoutShape : layoutShapes) {
            try {
                Element e = ConfigXmlManager.elementFromObject(layoutShape);
                if (e == null) continue;
                panel.addContent((Content)e);
            }
            catch (Exception e) {
                log.error("Error storing panel LayoutShape element", (Throwable)e);
            }
        }
        log.debug("Number of LayoutShape elements: {}", (Object)layoutShapes.size());
        Document doc = new Document(panel);
        XMLOutputter xMLOutputter = new XMLOutputter();
        xMLOutputter.setFormat(Format.getPrettyFormat().setLineSeparator(System.getProperty("line.separator")).setTextMode(Format.TextMode.TRIM));
        return xMLOutputter.outputString(doc);
    }

    private void replaceUserNameAttribute(@Nonnull Element e, @Nonnull String beanType, @Nonnull String attrName) {
        String sn;
        Attribute a = e.getAttribute(attrName);
        if (a == null) {
            return;
        }
        String un = a.getValue();
        switch (beanType) {
            case "turnout": {
                Turnout t = InstanceManager.getDefault(TurnoutManager.class).getTurnout(un);
                if (t == null) {
                    return;
                }
                sn = t.getSystemName();
                break;
            }
            case "layoutBlock": {
                LayoutBlock lb = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(un);
                if (lb == null) {
                    return;
                }
                sn = lb.getSystemName();
                break;
            }
            default: {
                return;
            }
        }
        if (!un.equals(sn)) {
            a.setValue(sn);
            log.debug("systemName '{}' replaced userName '{}' for {}", new Object[]{sn, un, attrName});
        }
    }

    private void replaceUserNameChild(@Nonnull Element e, @Nonnull String beanType, @Nonnull String childName) {
        String sn;
        Element c = e.getChild(childName);
        if (c == null) {
            return;
        }
        String un = c.getText();
        switch (beanType) {
            case "turnout": {
                Turnout t = InstanceManager.getDefault(TurnoutManager.class).getTurnout(un);
                if (t == null) {
                    return;
                }
                sn = t.getSystemName();
                break;
            }
            default: {
                return;
            }
        }
        if (!un.equals(sn)) {
            c.setText(sn);
            log.debug("systemName '{}' replaced userName '{}' for {}", new Object[]{sn, un, childName});
        }
    }

    private void replaceUserNames(@Nonnull Element e) {
        this.replaceUserNameAttribute(e, "turnout", "turnoutname");
        this.replaceUserNameAttribute(e, "turnout", "secondturnoutname");
        this.replaceUserNameAttribute(e, "layoutBlock", "blockname");
        this.replaceUserNameAttribute(e, "layoutBlock", "blockbname");
        this.replaceUserNameAttribute(e, "layoutBlock", "blockcname");
        this.replaceUserNameAttribute(e, "layoutBlock", "blockdname");
        this.replaceUserNameAttribute(e, "layoutBlock", "blocknameac");
        this.replaceUserNameAttribute(e, "layoutBlock", "blocknamebd");
        this.replaceUserNameChild(e, "turnout", "turnout");
        this.replaceUserNameChild(e, "turnout", "turnoutB");
    }

    @Override
    protected String getJsonPanel(String name) {
        return "ERROR JSON support not implemented";
    }
}

