/*
 * Decompiled with CFR 0.152.
 */
package jmri.web.servlet.panel;

import java.util.List;
import javax.servlet.annotation.WebServlet;
import javax.swing.JFrame;
import jmri.configurexml.ConfigXmlManager;
import jmri.jmrit.display.switchboardEditor.BeanSwitch;
import jmri.jmrit.display.switchboardEditor.SwitchboardEditor;
import jmri.web.servlet.panel.AbstractPanelServlet;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="SwitchboardServlet", urlPatterns={"/panel/Switchboard"})
public class SwitchboardServlet
extends AbstractPanelServlet {
    private static final Logger log = LoggerFactory.getLogger(SwitchboardServlet.class);

    @Override
    protected String getPanelType() {
        return "Switchboard";
    }

    @Override
    protected String getXmlPanel(String name) {
        log.debug("Getting {} for {}", (Object)this.getPanelType(), (Object)name);
        SwitchboardEditor editor = (SwitchboardEditor)this.getEditor(name);
        if (editor == null) {
            log.warn("Requested Switchboard [{}] does not exist.", (Object)name);
            return "ERROR Requested panel [" + name + "] does not exist.";
        }
        Element panel = new Element("panel");
        JFrame frame = editor.getTargetFrame();
        panel.setAttribute("name", name);
        panel.setAttribute("paneltype", this.getPanelType());
        panel.setAttribute("height", Integer.toString(frame.getContentPane().getHeight()));
        panel.setAttribute("width", Integer.toString(frame.getContentPane().getWidth()));
        panel.setAttribute("panelheight", Integer.toString(editor.getTargetPanel().getHeight()));
        panel.setAttribute("panelwidth", Integer.toString(editor.getTargetPanel().getWidth()));
        panel.setAttribute("showtooltips", editor.showToolTip() ? "yes" : "no");
        panel.setAttribute("controlling", editor.allControlling() ? "yes" : "no");
        panel.setAttribute("hideunconnected", editor.hideUnconnected() ? "yes" : "no");
        panel.setAttribute("rangemin", Integer.toString(editor.getPanelMenuRangeMin()));
        panel.setAttribute("rangemax", Integer.toString(editor.getPanelMenuRangeMax()));
        panel.setAttribute("type", editor.getSwitchType());
        panel.setAttribute("connection", editor.getSwitchManu());
        panel.setAttribute("shape", editor.getSwitchShape());
        panel.setAttribute("rows", Integer.toString(editor.getRows()));
        panel.setAttribute("total", Integer.toString(editor.getTotal()));
        panel.setAttribute("showusername", editor.showUserName());
        panel.setAttribute("defaulttextcolor", editor.getDefaultTextColor());
        panel.setAttribute("activecolor", editor.getActiveSwitchColor());
        panel.setAttribute("inactivecolor", editor.getInactiveSwitchColor());
        log.debug("webserver Switchboard panel attribs ready");
        Element color = new Element("backgroundColor");
        if (editor.getBackgroundColor() == null) {
            color.setAttribute("red", Integer.toString(192));
            color.setAttribute("green", Integer.toString(192));
            color.setAttribute("blue", Integer.toString(192));
        } else {
            color.setAttribute("red", Integer.toString(editor.getBackgroundColor().getRed()));
            color.setAttribute("green", Integer.toString(editor.getBackgroundColor().getGreen()));
            color.setAttribute("blue", Integer.toString(editor.getBackgroundColor().getBlue()));
        }
        panel.addContent((Content)color);
        List<BeanSwitch> _switches = editor.getSwitches();
        log.debug("SwbServlet contains {} switches", (Object)_switches.size());
        for (BeanSwitch sub : _switches) {
            if (sub == null) continue;
            try {
                Element e = ConfigXmlManager.elementFromObject(sub);
                if (e == null) continue;
                log.debug("element name: {}", (Object)e.getName());
                e.setAttribute("label", sub.getNameString());
                e.setAttribute("connected", "false");
                if (sub.getNamedBean() == null) {
                    log.debug("switch {} NOT connected", (Object)sub.getNameString());
                } else {
                    try {
                        e.setAttribute("id", sub.getNamedBean().getSystemName());
                        e.setAttribute("connected", "true");
                    }
                    catch (NullPointerException ex) {
                        log.debug("{} {} does not have a SystemName", (Object)e.getName(), (Object)e.getAttribute("name"));
                    }
                }
                e.setAttribute("textcolor", editor.getDefaultTextColor());
                e.setAttribute("type", editor.getSwitchType());
                e.setAttribute("connection", editor.getSwitchManu());
                e.setAttribute("shape", editor.getSwitchShape());
                this.parsePortableURIs(e);
                panel.addContent((Content)e);
            }
            catch (Exception ex) {
                log.error("Error reading xml panel element: {}", (Object)ex, (Object)ex);
            }
        }
        Document doc = new Document(panel);
        XMLOutputter out = new XMLOutputter();
        out.setFormat(Format.getPrettyFormat().setLineSeparator(System.getProperty("line.separator")).setTextMode(Format.TextMode.TRIM));
        return out.outputString(doc);
    }

    @Override
    protected String getJsonPanel(String name) {
        return "ERROR JSON support not implemented";
    }
}

