/*
 * Decompiled with CFR 0.152.
 */
package jmri.web.servlet.permission;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jmri.InstanceManager;
import jmri.PermissionManager;
import jmri.util.FileUtil;
import jmri.web.servlet.ServletUtil;
import jmri.web.servlet.permission.Bundle;

@WebServlet(name="PermissionServlet", urlPatterns={"/permission"})
public class PermissionServlet
extends HttpServlet {
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String theRequest;
        switch (theRequest = request.getRequestURI().substring("/permission/".length())) {
            case "login": {
                this.login(request, response);
                break;
            }
            case "logout": {
                this.logout(request, response);
                break;
            }
            default: {
                response.sendError(404);
            }
        }
    }

    private static void sendPage(String page, String message, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setHeader("Connection", "Keep-Alive");
        response.setContentType("text/html; charset=utf-8");
        response.getWriter().print(String.format(request.getLocale(), FileUtil.readURL(FileUtil.findURL(Bundle.getMessage(request.getLocale(), page))), Bundle.getMessage(request.getLocale(), "PermissionTitle"), InstanceManager.getDefault(ServletUtil.class).getNavBar(request.getLocale(), "/permission"), InstanceManager.getDefault(ServletUtil.class).getRailroadName(false), InstanceManager.getDefault(ServletUtil.class).getFooter(request.getLocale(), "/permission"), message));
    }

    private void login(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (request.getContentLength() > 0) {
            StringBuilder textBuilder = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream(), StandardCharsets.UTF_8));){
                int c;
                while ((c = reader.read()) != -1) {
                    textBuilder.append((char)c);
                }
            }
            PermissionManager mngr = InstanceManager.getDefault(PermissionManager.class);
            String username = null;
            String password = null;
            block14: for (String param : textBuilder.toString().split("&")) {
                String[] parts = param.split("=");
                switch (parts[0]) {
                    case "username": {
                        username = URLDecoder.decode(parts[1], StandardCharsets.UTF_8);
                        continue block14;
                    }
                    case "password": {
                        if (parts.length > 1) {
                            password = URLDecoder.decode(parts[1], StandardCharsets.UTF_8);
                            continue block14;
                        }
                        password = "";
                        continue block14;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown parameter: \"" + parts[0] + "\" with value \"" + parts[1] + "\"");
                    }
                }
            }
            if (username != null && password != null) {
                StringBuilder sessionId;
                boolean result;
                if (mngr.isAGuestUser(username)) {
                    String message = Bundle.getMessage("GuestMessage");
                    PermissionServlet.sendPage("Response.html", message, request, response);
                    return;
                }
                String sessId = PermissionServlet.getSessionId(request);
                if (sessId == null) {
                    sessId = "";
                }
                if (result = mngr.remoteLogin(sessionId = new StringBuilder(sessId), request.getLocale(), username, password)) {
                    PermissionServlet.setSessionId(sessionId.toString(), response);
                }
                String message = result ? Bundle.getMessage("LoginSuccessful") : Bundle.getMessage("BadUsernameOrPassword");
                PermissionServlet.sendPage("Response.html", message, request, response);
                return;
            }
        }
        response.setHeader("Connection", "Keep-Alive");
        response.setContentType("text/html; charset=utf-8");
        response.getWriter().print(String.format(request.getLocale(), FileUtil.readURL(FileUtil.findURL(Bundle.getMessage(request.getLocale(), "Login.html"))), Bundle.getMessage(request.getLocale(), "PermissionTitle"), InstanceManager.getDefault(ServletUtil.class).getNavBar(request.getLocale(), "/permission"), InstanceManager.getDefault(ServletUtil.class).getRailroadName(false), InstanceManager.getDefault(ServletUtil.class).getFooter(request.getLocale(), "/permission")));
    }

    private void logout(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String sessionId = PermissionServlet.getSessionId(request);
        InstanceManager.getDefault(PermissionManager.class).remoteLogout(sessionId);
        PermissionServlet.sendPage("Response.html", Bundle.getMessage("LogoutSuccessful"), request, response);
    }

    public static void permissionDenied(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String session = "";
        InstanceManager.getDefault(PermissionManager.class).remoteLogout(session);
        PermissionServlet.sendPage("Response.html", Bundle.getMessage("PermissionDenied"), request, response);
    }

    public static String getSessionId(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie c : cookies) {
            if (!"sessionId".equals(c.getName())) continue;
            return c.getValue();
        }
        return null;
    }

    public static void setSessionId(String sessionId, HttpServletResponse response) {
        Cookie cookie = new Cookie("sessionId", sessionId);
        cookie.setPath("/");
        response.addCookie(cookie);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "About Servlet";
    }
}

