/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb;

import org.openlcb.AddressedMessage;
import org.openlcb.MessageTypeIdentifier;
import org.openlcb.NodeID;
import org.openlcb.Utilities;

public abstract class AddressedPayloadMessage
extends AddressedMessage {
    protected byte[] payload;

    public byte[] getPayload() {
        return this.payload;
    }

    public AddressedPayloadMessage(NodeID source, NodeID dest, byte[] payload) {
        super(source, dest);
        this.payload = payload == null ? new byte[0] : (byte[])payload.clone();
    }

    @Override
    public String toString() {
        StringBuilder p = new StringBuilder(super.toString());
        p.append(" ");
        p.append(this.getEMTI().toString());
        if (this.payload.length > 0) {
            p.append(" with payload ");
            p.append(Utilities.toHexSpaceString(this.payload));
        } else {
            p.append(" with no payload");
        }
        return p.toString();
    }

    public abstract MessageTypeIdentifier getEMTI();

    @Override
    public int getMTI() {
        return this.getEMTI().mti();
    }
}

