/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb;

import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.openlcb.AddressedPayloadMessage;
import org.openlcb.Connection;
import org.openlcb.MessageDecoder;
import org.openlcb.MessageTypeIdentifier;
import org.openlcb.NodeID;

@Immutable
@ThreadSafe
public class DatagramAcknowledgedMessage
extends AddressedPayloadMessage {
    int flags;

    public DatagramAcknowledgedMessage(NodeID source, NodeID dest) {
        super(source, dest, null);
        this.flags = 0;
    }

    public DatagramAcknowledgedMessage(NodeID source, NodeID dest, int flags) {
        super(source, dest, new byte[]{(byte)flags});
        this.flags = flags;
    }

    public int getFlags() {
        return this.flags;
    }

    @Override
    public void applyTo(MessageDecoder decoder, Connection sender) {
        decoder.handleDatagramAcknowledged(this, sender);
    }

    @Override
    public String toString() {
        StringBuilder p = new StringBuilder(super.toString());
        p.append(" flags 0x");
        p.append(Integer.toHexString(this.getFlags()).toUpperCase());
        return p.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof DatagramAcknowledgedMessage)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.flags == ((DatagramAcknowledgedMessage)o).flags;
    }

    @Override
    public MessageTypeIdentifier getEMTI() {
        return MessageTypeIdentifier.DatagramReceivedOK;
    }
}

