/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb;

import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.annotations.NonNull;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.openlcb.NodeID;
import org.openlcb.Utilities;

@Immutable
@ThreadSafe
public class EventID {
    static final int BYTECOUNT = 8;
    byte[] contents;

    @CheckReturnValue
    public EventID(@NonNull NodeID node, int b7, int b8) {
        this.contents = new byte[8];
        System.arraycopy(node.contents, 0, this.contents, 0, 6);
        this.contents[6] = (byte)b7;
        this.contents[7] = (byte)b8;
    }

    @CheckReturnValue
    public EventID(@NonNull byte[] contents) {
        if (contents == null) {
            throw new IllegalArgumentException("null argument invalid");
        }
        if (contents.length != 8) {
            throw new IllegalArgumentException("Wrong EventID length: " + contents.length);
        }
        this.contents = new byte[8];
        System.arraycopy(contents, 0, this.contents, 0, 8);
    }

    @CheckReturnValue
    public EventID(@NonNull String value) {
        if (value == null) {
            throw new IllegalArgumentException("null argument invalid");
        }
        byte[] data = Utilities.bytesFromHexString(value);
        if (data.length != 8) {
            throw new IllegalArgumentException("Wrong EventID length: " + data.length);
        }
        this.contents = new byte[8];
        System.arraycopy(data, 0, this.contents, 0, 8);
    }

    @CheckReturnValue
    public EventID(long value) {
        this.contents = new byte[8];
        for (int index = 0; index < 8; ++index) {
            this.contents[index] = (byte)(value >> 8 * (7 - index) & 0xFFL);
        }
    }

    @CheckReturnValue
    @NonNull
    public byte[] getContents() {
        byte[] retval = new byte[8];
        System.arraycopy(this.contents, 0, retval, 0, 8);
        return retval;
    }

    @CheckReturnValue
    public boolean equals(Object o) {
        try {
            EventID other = (EventID)o;
            for (int i = 0; i < 8; ++i) {
                if (other.contents[i] == this.contents[i]) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean startsWith(NodeID id) {
        for (int i = 0; i < 6; ++i) {
            if (this.contents[i] == id.contents[i]) continue;
            return false;
        }
        return true;
    }

    @CheckReturnValue
    public int hashCode() {
        return (this.contents[0] << 21) + (this.contents[1] << 18) + (this.contents[2] << 15) + (this.contents[3] << 12) + (this.contents[4] << 9) + (this.contents[5] << 6) + (this.contents[6] << 3) + this.contents[7];
    }

    @CheckReturnValue
    @NonNull
    public String toString() {
        return "EventID:" + Utilities.toHexDotsString(this.contents);
    }

    @CheckReturnValue
    @NonNull
    public String toShortString() {
        return Utilities.toHexDotsString(this.contents);
    }

    public long toLong() {
        long ret = 0L;
        for (int i = 0; i < 8; ++i) {
            ret <<= 8;
            byte e = this.contents[i];
            ret |= (long)(e & 0xFF);
        }
        return ret;
    }

    public long rangeSuffix() {
        long eid = this.toLong();
        long sampleBit = eid & 1L;
        long mask = 0L;
        while ((eid & 1L) == sampleBit) {
            mask = mask << 1 | 1L;
            eid >>= 1;
        }
        return mask;
    }

    public String parse() {
        String eid;
        switch (eid = this.toShortString().substring(0, 2)) {
            case "00": {
                return this.reserved();
            }
            case "01": {
                return this.wellKnown();
            }
            case "09": {
                if (!this.toShortString().startsWith("09.00.99.FF")) break;
                return this.trainSearch();
            }
        }
        return "";
    }

    protected String reserved() {
        return "Reserved " + this.toShortString();
    }

    protected String wellKnown() {
        String eid;
        switch (eid = this.toShortString()) {
            case "01.00.00.00.00.00.FF.FF": {
                return "Emergency off";
            }
            case "01.00.00.00.00.00.FF.FE": {
                return "Clear Emergency Off";
            }
            case "01.00.00.00.00.00.FF.FD": {
                return "Emergency stop of all operations";
            }
            case "01.00.00.00.00.00.FF.FC": {
                return "Clear emergency stop of all operations";
            }
            case "01.00.00.00.00.00.FF.F8": {
                return "Node recorded a new log entry";
            }
            case "01.00.00.00.00.00.FF.F1": {
                return "Power supply brownout detected below minimum required by node";
            }
            case "01.00.00.00.00.00.FF.F0": {
                return "Power supply brownout detected below minimum required by standard";
            }
            case "01.00.00.00.00.00.FE.00": {
                return "Ident button combination pressed";
            }
            case "01.00.00.00.00.00.FD.01": {
                return "Link error code 1 \u2013 the specific meaning is link wire protocol specific";
            }
            case "01.00.00.00.00.00.FD.02": {
                return "Link error code 2";
            }
            case "01.00.00.00.00.00.FD.03": {
                return "Link error code 3";
            }
            case "01.00.00.00.00.00.FD.04": {
                return "Link error code 4";
            }
            case "01.01.00.00.00.00.02.01": {
                return "Duplicate Node ID Detected";
            }
            case "01.01.00.00.00.00.03.03": {
                return "This node is a Train";
            }
            case "01.01.00.00.00.00.03.04": {
                return "This node is a Train Control Proxy";
            }
            case "01.01.00.00.00.00.06.01": {
                return "Firmware Corrupted";
            }
            case "01.01.00.00.00.00.06.02": {
                return "Firmware Upgrade Request by Hardware Switch";
            }
        }
        if (eid.startsWith("01.01.00.00.01")) {
            return this.fastClock();
        }
        if (eid.startsWith("01.01.02")) {
            return this.dccRange();
        }
        return "Well-Known " + eid;
    }

    protected String fastClock() {
        String set;
        String clockNum = this.toShortString().substring(16, 17);
        byte[] contents = this.getContents();
        int lowByte = contents[7] & 0xFF;
        int highByte = contents[6] & 0xFF;
        int highByteMasked = 0x7F & highByte;
        int bothBytes = highByte * 256 + lowByte;
        String function = "";
        String string = set = (0x80 & highByte) == 128 ? "Set " : "";
        if ((highByte & 0xF0) == 192) {
            int rate = (highByte & 0xF) * 256 + lowByte;
            function = "Set rate " + (double)rate / 4.0;
        } else if (bothBytes == 61440) {
            function = "Query";
        } else if (bothBytes == 61441) {
            function = "Stop";
        } else if (bothBytes == 61442) {
            function = "Start";
        } else if (bothBytes == 61443) {
            function = "Date Rollover";
        } else if (highByteMasked < 24) {
            String lowString = "00" + Integer.toString(lowByte);
            lowString = lowString.substring(lowString.length() - 2);
            function = set + "time " + highByteMasked + ":" + lowString;
        } else if (highByteMasked <= 44) {
            String lowString = "00" + Integer.toString(lowByte);
            lowString = lowString.substring(lowString.length() - 2);
            function = set + "date " + (highByteMasked - 32) + "/" + lowString;
        } else if (highByteMasked < 64) {
            int year = highByteMasked * 256 + lowByte - 12288;
            function = set + "year " + year;
        } else {
            function = "reserved";
        }
        return "Fast Clock " + clockNum + " " + function;
    }

    protected String dccRange() {
        String eid = this.toShortString();
        if (eid.startsWith("01.01.02.00.00.FF")) {
            return "DCC Acc Decoder " + this.parseAccDecoderNumber(this.toLong()) + " active";
        }
        if (eid.startsWith("01.01.02.00.00.FE")) {
            return "DCC Acc Decoder " + this.parseAccDecoderNumber(this.toLong()) + " inactive";
        }
        if (eid.startsWith("01.01.02.00.00.FD")) {
            return "DCC Turnout Feedback " + (this.toLong() & 0x7FFL) + " active";
        }
        if (eid.startsWith("01.01.02.00.00.FC")) {
            return "DCC Turnout Feedback " + (this.toLong() & 0x7FFL) + " inactive";
        }
        if (eid.startsWith("01.01.02.00.00.FB")) {
            return "DCC Sensor " + (this.toLong() & 0xFFFL) + " active";
        }
        if (eid.startsWith("01.01.02.00.00.FA")) {
            return "DCC Sensor " + (this.toLong() & 0xFFFL) + " inactive";
        }
        if (eid.startsWith("01.01.02.00.01")) {
            return "DCC Extended Accessory " + (this.toLong() >> 8 & 0x7FFL) + " " + (this.toLong() & 0xFFL);
        }
        return "DCC Well-Known " + this;
    }

    protected String parseAccDecoderNumber(long event) {
        int input = (int)(event & 0xFFFL);
        int result = (input - 8 >> 1) + 1 & 0x7FF;
        if ((event & 1L) != 0L) {
            return "" + result + " N/C/On ";
        }
        return "" + result + " R/T/Off";
    }

    protected String trainSearch() {
        return "Train Search";
    }
}

