/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb;

import org.openlcb.MessageTypeIdentifier;

public enum EventState {
    Valid(0),
    Invalid(1),
    Unknown(3),
    Reserved(2);

    private final int modifier;

    private EventState(int modifier) {
        this.modifier = modifier;
    }

    public int getModifier() {
        return this.modifier;
    }

    public MessageTypeIdentifier getProducerIdentifierMti() {
        int rawMti = MessageTypeIdentifier.ProducerIdentifiedValid.mti();
        rawMti &= 0xFFFFFFFC;
        return MessageTypeIdentifier.get(rawMti |= this.modifier);
    }

    public MessageTypeIdentifier getConsumerIdentifierMti() {
        int rawMti = MessageTypeIdentifier.ConsumerIdentifiedValid.mti();
        rawMti &= 0xFFFFFFFC;
        return MessageTypeIdentifier.get(rawMti |= this.modifier);
    }

    public EventState inverted() {
        switch (this) {
            case Valid: {
                return Invalid;
            }
            case Invalid: {
                return Valid;
            }
        }
        return this;
    }
}

