/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb;

import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.openlcb.Connection;
import org.openlcb.Message;
import org.openlcb.MessageDecoder;
import org.openlcb.NodeID;

@Immutable
@ThreadSafe
public class InitializationCompleteMessage
extends Message {
    final boolean hasSimpleProtocol;

    public InitializationCompleteMessage(NodeID source) {
        super(source);
        this.hasSimpleProtocol = false;
    }

    public InitializationCompleteMessage(NodeID source, boolean hasSimpleProtocol) {
        super(source);
        this.hasSimpleProtocol = hasSimpleProtocol;
    }

    public boolean hasSimpleProtocol() {
        return this.hasSimpleProtocol;
    }

    @Override
    public void applyTo(MessageDecoder decoder, Connection sender) {
        decoder.handleInitializationComplete(this, sender);
    }

    @Override
    public String toString() {
        return super.toString() + " Initialization Complete" + (this.hasSimpleProtocol() ? " with Simple Protocol" : "");
    }

    @Override
    public int getMTI() {
        return MTI_INITIALIZATION_COMPLETE;
    }
}

