/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb;

import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.annotations.NonNull;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.openlcb.Utilities;

@Immutable
@ThreadSafe
public class NodeID {
    static final int BYTECOUNT = 6;
    byte[] contents;

    @CheckReturnValue
    public NodeID(@NonNull NodeID node) {
        this(node.contents);
    }

    @CheckReturnValue
    public NodeID() {
        this(new byte[]{0, 0, 0, 0, 0, 0});
    }

    @CheckReturnValue
    public NodeID(@NonNull byte[] contents) {
        if (contents == null) {
            throw new IllegalArgumentException("null argument invalid");
        }
        if (contents.length < 6) {
            throw new IllegalArgumentException("Wrong NodeID length: " + contents.length);
        }
        this.contents = new byte[6];
        for (int i = 0; i < 6; ++i) {
            this.contents[i] = contents[i];
        }
    }

    @CheckReturnValue
    public NodeID(@NonNull String value) {
        if (value == null) {
            throw new IllegalArgumentException("null argument invalid");
        }
        byte[] contents = Utilities.bytesFromHexString(value);
        if (contents.length < 6) {
            throw new IllegalArgumentException("Wrong NodeID length: " + contents.length);
        }
        this.contents = new byte[6];
        for (int i = 0; i < 6; ++i) {
            this.contents[i] = contents[i];
        }
    }

    @CheckReturnValue
    public NodeID(long value) {
        byte[] c = new byte[6];
        Utilities.HostToNetworkUint48(c, 0, value);
        this.contents = c;
    }

    @CheckReturnValue
    public boolean equals(Object o) {
        try {
            NodeID other = (NodeID)o;
            for (int i = 0; i < 6; ++i) {
                if (other.contents[i] == this.contents[i]) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @CheckReturnValue
    public int hashCode() {
        return this.contents[0] + this.contents[1] << 5 + this.contents[2] << 10 + this.contents[3] << 15 + this.contents[4] << 20 + this.contents[5] << 25;
    }

    public long toLong() {
        long retval = 0L;
        retval |= (long)(this.contents[0] & 0xFF);
        retval <<= 8;
        retval |= (long)(this.contents[1] & 0xFF);
        retval <<= 8;
        retval |= (long)(this.contents[2] & 0xFF);
        retval <<= 8;
        retval |= (long)(this.contents[3] & 0xFF);
        retval <<= 8;
        retval |= (long)(this.contents[4] & 0xFF);
        retval <<= 8;
        return retval |= (long)(this.contents[5] & 0xFF);
    }

    @CheckReturnValue
    @NonNull
    public byte[] getContents() {
        byte[] retval = new byte[6];
        for (int i = 0; i < 6; ++i) {
            retval[i] = this.contents[i];
        }
        return retval;
    }

    @CheckReturnValue
    @NonNull
    public String toString() {
        return Utilities.toHexDotsString(this.contents);
    }
}

