/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.openlcb.AbstractConnection;
import org.openlcb.AddressedMessage;
import org.openlcb.Connection;
import org.openlcb.InitializationCompleteMessage;
import org.openlcb.Message;
import org.openlcb.MimicNodeStore;
import org.openlcb.NodeID;
import org.openlcb.OlcbThreadFactory;
import org.openlcb.cdi.impl.ConfigRepresentation;
import org.openlcb.implementations.DatagramMeteringBuffer;
import org.openlcb.implementations.DatagramService;
import org.openlcb.implementations.EventTable;
import org.openlcb.implementations.MemoryConfigurationService;
import org.openlcb.protocols.UnknownMtiHandler;
import org.openlcb.protocols.VerifyNodeIdHandler;

public class OlcbInterface {
    private static final Logger log = Logger.getLogger(OlcbInterface.class.getName());
    private final Timer timer = new Timer();
    protected final Connection internalOutputConnection;
    protected final Connection outputConnection;
    private final OutputConnectionSniffer wrappedOutputConnection;
    private final QueuedOutputConnection queuedOutputConnection;
    private final MessageDispatcher inputConnection;
    private final NodeID nodeId;
    private final MimicNodeStore nodeStore;
    private final DatagramMeteringBuffer dmb;
    private final DatagramService dcs;
    private MemoryConfigurationService mcs;
    private final Map<NodeID, ConfigRepresentation> nodeConfigs = new HashMap<NodeID, ConfigRepresentation>();
    private EventTable eventTable = null;
    private ThreadPoolExecutor threadPool = null;
    static final int minThreads = 10;
    static final int maxThreads = 100;
    static final long threadTimeout = 10L;
    private SyncExecutor loopbackThread = null;

    @Deprecated
    public OlcbInterface(NodeID nodeId_, Connection outputConnection_) {
        this(nodeId_, outputConnection_, new ThreadPoolExecutor(10, 100, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new OlcbThreadFactory()));
        this.threadPool.allowCoreThreadTimeOut(true);
    }

    public OlcbInterface(NodeID nodeId_, Connection outputConnection_, ThreadPoolExecutor tpe) {
        this.threadPool = tpe;
        this.nodeId = nodeId_;
        this.internalOutputConnection = outputConnection_;
        this.wrappedOutputConnection = new OutputConnectionSniffer(this.internalOutputConnection);
        this.queuedOutputConnection = new QueuedOutputConnection(this.wrappedOutputConnection);
        this.outputConnection = this.queuedOutputConnection;
        this.inputConnection = new MessageDispatcher();
        this.nodeStore = new MimicNodeStore(this.getOutputConnection(), this.nodeId);
        this.dmb = new DatagramMeteringBuffer(this.getOutputConnection(), this.threadPool);
        this.dcs = new DatagramService(this.nodeId, this.dmb);
        this.mcs = new MemoryConfigurationService(this.nodeId, this.dcs);
        this.inputConnection.registerMessageListener(this.nodeStore);
        this.inputConnection.registerMessageListener(this.dmb.connectionForRepliesFromDownstream());
        this.inputConnection.registerMessageListener(this.dcs);
        new UnknownMtiHandler(this.nodeId, this);
        new VerifyNodeIdHandler(this.nodeId, this);
        this.outputConnection.registerStartNotification(new Connection.ConnectionListener(){

            @Override
            public void connectionActive(Connection c) {
                InitializationCompleteMessage m = new InitializationCompleteMessage(OlcbInterface.this.nodeId);
                OlcbInterface.this.outputConnection.put(m, OlcbInterface.this.getInputConnection());
                OlcbInterface.this.threadPool.execute(new Runnable(){

                    @Override
                    public void run() {
                        OlcbInterface.this.queuedOutputConnection.run();
                    }
                });
            }
        });
    }

    public void setLoopbackThread(SyncExecutor thread) {
        this.loopbackThread = thread;
    }

    public void runOnThreadPool(Runnable r) {
        this.threadPool.execute(r);
    }

    public Timer getTimer() {
        return this.timer;
    }

    public Connection getInputConnection() {
        return this.inputConnection;
    }

    public Connection getOutputConnection() {
        return this.outputConnection;
    }

    public NodeID getNodeId() {
        return this.nodeId;
    }

    public MimicNodeStore getNodeStore() {
        return this.nodeStore;
    }

    public DatagramService getDatagramService() {
        return this.dcs;
    }

    public DatagramMeteringBuffer getDatagramMeteringBuffer() {
        return this.dmb;
    }

    public MemoryConfigurationService getMemoryConfigurationService() {
        return this.mcs;
    }

    public void injectMemoryConfigurationService(MemoryConfigurationService s) {
        this.mcs = s;
    }

    public synchronized EventTable getEventTable() {
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        return this.eventTable;
    }

    public synchronized ConfigRepresentation getConfigForNode(NodeID remoteNode) {
        if (this.nodeConfigs.containsKey(remoteNode)) {
            return this.nodeConfigs.get(remoteNode);
        }
        ConfigRepresentation rep = new ConfigRepresentation(this, remoteNode);
        this.nodeConfigs.put(remoteNode, rep);
        return rep;
    }

    public synchronized void dropConfigForNode(NodeID remoteNode) {
        if (this.nodeConfigs.containsKey(remoteNode)) {
            this.nodeConfigs.remove(remoteNode);
        }
    }

    public void flushSendQueue() {
        this.dmb.waitForSendQueue();
        this.queuedOutputConnection.waitForSendQueue();
    }

    public void registerMessageListener(Connection c) {
        this.inputConnection.registerMessageListener(c);
    }

    public void unRegisterMessageListener(Connection c) {
        this.inputConnection.unRegisterMessageListener(c);
    }

    public int numMessageListeners() {
        return this.inputConnection.numListeners();
    }

    void runCallbackOrAbandon(Runnable r) {
        if (this.loopbackThread != null) {
            try {
                this.loopbackThread.schedule(r);
            }
            catch (InterruptedException e) {
                return;
            }
        } else {
            r.run();
        }
    }

    public void dispose() {
        this.timer.cancel();
        if (this.threadPool != null && !this.threadPool.isShutdown()) {
            this.threadPool.shutdown();
            try {
                if (!this.threadPool.awaitTermination(100L, TimeUnit.MILLISECONDS)) {
                    this.threadPool.shutdownNow();
                    if (!this.threadPool.awaitTermination(100L, TimeUnit.MILLISECONDS)) {
                        log.warning("Pool did not terminate");
                    }
                }
            }
            catch (InterruptedException ie) {
                this.threadPool.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
        this.threadPool = null;
        this.dmb.dispose();
        this.mcs.dispose();
        this.nodeStore.dispose();
    }

    class MessageDispatcher
    extends AbstractConnection {
        private List<Connection> listeners = new ArrayList<Connection>();
        private List<Connection> pendingListeners = new ArrayList<Connection>();
        private List<Connection> unpendingListeners = new ArrayList<Connection>();

        MessageDispatcher() {
        }

        public synchronized void registerMessageListener(Connection c) {
            this.pendingListeners.add(c);
        }

        public synchronized void unRegisterMessageListener(Connection c) {
            this.unpendingListeners.add(c);
        }

        public synchronized int numListeners() {
            return this.listeners.size() + this.pendingListeners.size() - this.unpendingListeners.size();
        }

        @Override
        public synchronized void put(Message msg, Connection sender) {
            if (!this.pendingListeners.isEmpty() || !this.unpendingListeners.isEmpty()) {
                this.listeners.addAll(this.pendingListeners);
                this.pendingListeners.clear();
                this.listeners.removeAll(this.unpendingListeners);
                this.unpendingListeners.clear();
            }
            for (Connection c : this.listeners) {
                c.put(msg, sender);
            }
        }
    }

    private class QueuedOutputConnection
    implements Connection {
        private final Connection realOutput;
        private final BlockingQueue<QEntry> outputQueue = new LinkedBlockingQueue<QEntry>();
        private int pendingCount = 0;

        QueuedOutputConnection(Connection realOutput) {
            this.realOutput = realOutput;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void put(Message msg, Connection sender) {
            QueuedOutputConnection queuedOutputConnection = this;
            synchronized (queuedOutputConnection) {
                ++this.pendingCount;
            }
            this.outputQueue.add(new QEntry(msg, sender));
        }

        @Override
        public void registerStartNotification(Connection.ConnectionListener c) {
            OlcbInterface.this.internalOutputConnection.registerStartNotification(c);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForSendQueue() {
            while (true) {
                QueuedOutputConnection queuedOutputConnection = this;
                synchronized (queuedOutputConnection) {
                    if (this.pendingCount == 0) {
                        return;
                    }
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }

        private void run() {
            final ArrayList<QEntry> l = new ArrayList<QEntry>(150);
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    QEntry m = this.outputQueue.take();
                    l.clear();
                    l.add(m);
                    this.outputQueue.drainTo(l, 149);
                    OlcbInterface.this.runCallbackOrAbandon(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            for (QEntry m : l) {
                                try {
                                    QueuedOutputConnection.this.realOutput.put(m.message, m.connection);
                                }
                                catch (RejectedExecutionException ex) {
                                    throw ex;
                                }
                                catch (Throwable e) {
                                    log.warning("Exception while sending message: " + e.toString());
                                    e.printStackTrace();
                                }
                                QueuedOutputConnection queuedOutputConnection = QueuedOutputConnection.this;
                                synchronized (queuedOutputConnection) {
                                    QueuedOutputConnection.this.pendingCount--;
                                }
                            }
                        }
                    });
                }
                catch (InterruptedException | RejectedExecutionException e) {
                    return;
                }
            }
        }

        private class QEntry {
            Message message;
            Connection connection;

            QEntry(Message m, Connection c) {
                this.message = m;
                this.connection = c;
            }
        }
    }

    public static interface SyncExecutor {
        public void schedule(Runnable var1) throws InterruptedException;
    }

    class OutputConnectionSniffer
    implements Connection {
        private final Connection realOutput;

        OutputConnectionSniffer(Connection realOutput) {
            this.realOutput = realOutput;
        }

        @Override
        public void put(Message msg, Connection sender) {
            if (msg instanceof AddressedMessage) {
                AddressedMessage amsg = (AddressedMessage)msg;
                if (amsg.destNodeID.equals(OlcbInterface.this.nodeId)) {
                    OlcbInterface.this.inputConnection.put(msg, sender);
                    return;
                }
                OlcbInterface.this.nodeStore.put(msg, sender);
            } else {
                OlcbInterface.this.inputConnection.put(msg, sender);
            }
            this.realOutput.put(msg, sender);
        }

        @Override
        public void registerStartNotification(Connection.ConnectionListener c) {
            this.realOutput.registerStartNotification(c);
        }
    }
}

