/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.openlcb.Connection;
import org.openlcb.EventID;
import org.openlcb.EventMessage;
import org.openlcb.MessageDecoder;
import org.openlcb.NodeID;

@Immutable
@ThreadSafe
public class ProducerConsumerEventReportMessage
extends EventMessage {
    List<Byte> payload;

    public ProducerConsumerEventReportMessage(NodeID source, EventID eventID) {
        super(source, eventID);
        this.payload = null;
    }

    public ProducerConsumerEventReportMessage(NodeID source, EventID eventID, List<Byte> payload) {
        super(source, eventID);
        this.payload = payload;
    }

    public ProducerConsumerEventReportMessage(NodeID source, EventID eventID, byte[] bytes) {
        super(source, eventID);
        this.payload = new ArrayList<Byte>();
        for (byte value : bytes) {
            this.payload.add(value);
        }
    }

    @Override
    public void applyTo(MessageDecoder decoder, Connection sender) {
        decoder.handleProducerConsumerEventReport(this, sender);
    }

    public int getPayloadSize() {
        if (this.payload == null) {
            return 0;
        }
        return this.payload.size();
    }

    @NonNull
    public List getPayloadList() {
        if (this.payload == null) {
            return Collections.unmodifiableList(new ArrayList());
        }
        return Collections.unmodifiableList(this.payload);
    }

    @NonNull
    public byte[] getPayloadArray() {
        if (this.payload == null) {
            return new byte[0];
        }
        byte[] result = new byte[this.payload.size()];
        int i = 0;
        for (Byte b : this.payload) {
            result[i++] = b;
        }
        return result;
    }

    @Override
    public String toString() {
        String retval = super.toString() + " Producer/Consumer Event Report  " + this.eventID.toString();
        if (this.getPayloadSize() > 0) {
            retval = retval + " payload of " + this.getPayloadSize() + " : ";
            int n = this.getPayloadSize();
            boolean first = true;
            for (byte data : this.payload) {
                if (!first) {
                    retval = retval + ".";
                }
                retval = retval + Integer.toHexString(data & 0xFF).toUpperCase();
                first = false;
            }
        }
        return retval;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof ProducerConsumerEventReportMessage)) {
            return false;
        }
        ProducerConsumerEventReportMessage p = (ProducerConsumerEventReportMessage)o;
        if (this.payload == null && (p.payload == null || p.payload.size() == 0)) {
            return true;
        }
        return this.getPayloadList().equals(p.getPayloadList());
    }

    @Override
    public int hashCode() {
        int payloadHash = 0;
        if (this.payload != null && this.payload.size() != 0) {
            payloadHash = this.payload.hashCode();
        }
        return super.hashCode() | payloadHash;
    }

    @Override
    public int getMTI() {
        return 4818;
    }
}

