/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb;

import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.openlcb.AddressedPayloadMessage;
import org.openlcb.Connection;
import org.openlcb.MessageDecoder;
import org.openlcb.MessageTypeIdentifier;
import org.openlcb.NodeID;
import org.openlcb.Utilities;

@Immutable
@ThreadSafe
public class ProtocolIdentificationReplyMessage
extends AddressedPayloadMessage {
    long value;

    public ProtocolIdentificationReplyMessage(NodeID source, NodeID dest, long value) {
        super(source, dest, ProtocolIdentificationReplyMessage.toPayload(value));
        this.value = value;
    }

    private static byte[] toPayload(long value) {
        byte[] b = new byte[6];
        Utilities.HostToNetworkUint48(b, 0, value);
        return b;
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof ProtocolIdentificationReplyMessage)) {
            return false;
        }
        ProtocolIdentificationReplyMessage msg = (ProtocolIdentificationReplyMessage)o;
        if (this.value != msg.getValue()) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public void applyTo(MessageDecoder decoder, Connection sender) {
        decoder.handleProtocolIdentificationReply(this, sender);
    }

    @Override
    public MessageTypeIdentifier getEMTI() {
        return MessageTypeIdentifier.ProtocolSupportReply;
    }

    @Override
    public int getMTI() {
        return 4852;
    }
}

