/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb;

import java.nio.charset.Charset;
import org.openlcb.Connection;
import org.openlcb.NodeID;
import org.openlcb.SimpleNodeIdentInfoReplyMessage;
import org.openlcb.SimpleNodeIdentInfoRequestMessage;

public class SimpleNodeIdent {
    NodeID source;
    NodeID dest;
    static final Charset UTF8 = Charset.forName("UTF8");
    static final int MAX_REPLY_LENGTH = 256;
    byte[] bytes = new byte[256];
    int next = 0;

    public SimpleNodeIdent(SimpleNodeIdentInfoReplyMessage msg) {
        this.addMsg(msg);
    }

    public SimpleNodeIdent(NodeID source, NodeID dest) {
        this.source = source;
        this.dest = dest;
    }

    void start(Connection connection) {
        this.next = 0;
        connection.put(new SimpleNodeIdentInfoRequestMessage(this.source, this.dest), null);
    }

    public void addMsg(SimpleNodeIdentInfoReplyMessage msg) {
        if (this.contentComplete()) {
            this.bytes = new byte[256];
            this.next = 0;
        }
        byte[] data = msg.getData();
        for (int i = 0; i < data.length; ++i) {
            this.bytes[this.next++] = data[i];
        }
    }

    public boolean contentComplete() {
        int strings = 0;
        for (int i = 0; i < this.next; ++i) {
            if (this.bytes[i] != 0) continue;
            ++strings;
        }
        return strings == 6;
    }

    public String getMfgName() {
        int len;
        int start = 1;
        for (len = 1; len < this.bytes.length && this.bytes[len] != 0; ++len) {
        }
        String s = new String(this.bytes, start, len - start, UTF8);
        if (s == null) {
            return "";
        }
        return s;
    }

    public String getModelName() {
        int len;
        int start = 1;
        for (len = 1; len < this.bytes.length && this.bytes[len] != 0; ++len) {
        }
        start = ++len;
        while (len < this.bytes.length && this.bytes[len] != 0) {
            ++len;
        }
        String s = new String(this.bytes, start, len - start, UTF8);
        if (s == null) {
            return "";
        }
        return s;
    }

    public String getHardwareVersion() {
        int len = 1;
        int start = 1;
        for (int i = 0; i < 2; ++i) {
            while (len < this.bytes.length && this.bytes[len] != 0) {
                ++len;
            }
            start = ++len;
        }
        while (len < this.bytes.length && this.bytes[len] != 0) {
            ++len;
        }
        String s = new String(this.bytes, start, len - start, UTF8);
        if (s == null) {
            return "";
        }
        return s;
    }

    public String getSoftwareVersion() {
        int len = 1;
        int start = 1;
        for (int i = 0; i < 3; ++i) {
            while (len < this.bytes.length && this.bytes[len] != 0) {
                ++len;
            }
            start = ++len;
        }
        while (len < this.bytes.length && this.bytes[len] != 0) {
            ++len;
        }
        String s = new String(this.bytes, start, len - start, UTF8);
        if (s == null) {
            return "";
        }
        return s;
    }

    public String getUserName() {
        int len = 1;
        int start = 1;
        for (int i = 0; i < 4; ++i) {
            while (len < this.bytes.length && this.bytes[len] != 0) {
                ++len;
            }
            start = ++len;
        }
        if (len < this.bytes.length) {
            start = ++len;
        }
        while (len < this.bytes.length && this.bytes[len] != 0) {
            ++len;
        }
        String s = new String(this.bytes, start, len - start, UTF8);
        if (s == null) {
            return "";
        }
        return s;
    }

    public String getUserDesc() {
        int i;
        int len = 1;
        int start = 1;
        for (i = 0; i < 4; ++i) {
            while (len < this.bytes.length && this.bytes[len] != 0) {
                ++len;
            }
            start = ++len;
        }
        if (len < this.bytes.length) {
            start = ++len;
        }
        for (i = 0; i < 1; ++i) {
            while (len < this.bytes.length && this.bytes[len] != 0) {
                ++len;
            }
            start = ++len;
        }
        while (len < this.bytes.length && this.bytes[len] != 0) {
            ++len;
        }
        String s = new String(this.bytes, start, len - start, UTF8);
        if (s == null) {
            return "";
        }
        return s;
    }
}

