/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb;

import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.openlcb.AddressedPayloadMessage;
import org.openlcb.Connection;
import org.openlcb.MessageDecoder;
import org.openlcb.MessageTypeIdentifier;
import org.openlcb.NodeID;

@Immutable
@ThreadSafe
public class SimpleNodeIdentInfoReplyMessage
extends AddressedPayloadMessage {
    public SimpleNodeIdentInfoReplyMessage(NodeID source, NodeID dest, byte[] dataIn) {
        super(source, dest, dataIn);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof SimpleNodeIdentInfoReplyMessage)) {
            return false;
        }
        SimpleNodeIdentInfoReplyMessage msg = (SimpleNodeIdentInfoReplyMessage)o;
        if (this.getData().length != msg.getData().length) {
            return false;
        }
        int n = this.getData().length;
        byte[] d1 = this.getData();
        byte[] d2 = msg.getData();
        for (int i = 0; i < n; ++i) {
            if (d1[i] == d2[i]) continue;
            return false;
        }
        return super.equals(o);
    }

    public byte[] getData() {
        return this.payload;
    }

    @Override
    public void applyTo(MessageDecoder decoder, Connection sender) {
        decoder.handleSimpleNodeIdentInfoReply(this, sender);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getSourceNodeID().toString());
        b.append(" - ");
        b.append(this.getDestNodeID().toString());
        b.append(" Simple Node Ident Info with content '");
        for (byte d : this.getData()) {
            if (d == 0) {
                b.append(',');
                continue;
            }
            if (d < 32) {
                b.append(Integer.toString(d));
                b.append(',');
                continue;
            }
            b.append((char)d);
        }
        b.append('\'');
        return b.toString();
    }

    @Override
    public MessageTypeIdentifier getEMTI() {
        return MessageTypeIdentifier.SimpleNodeIdentInfoReply;
    }
}

