/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb;

import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.openlcb.AddressedPayloadMessage;
import org.openlcb.Connection;
import org.openlcb.MessageDecoder;
import org.openlcb.MessageTypeIdentifier;
import org.openlcb.NodeID;

@Immutable
@ThreadSafe
public class StreamDataCompleteMessage
extends AddressedPayloadMessage {
    byte sourceStreamID;
    byte destStreamID;

    public StreamDataCompleteMessage(NodeID source, NodeID dest, byte sourceStreamID, byte destStreamID) {
        super(source, dest, new byte[]{sourceStreamID, destStreamID});
        this.sourceStreamID = sourceStreamID;
        this.destStreamID = destStreamID;
    }

    public byte getSourceStreamID() {
        return this.sourceStreamID;
    }

    public byte getDestinationStreamID() {
        return this.destStreamID;
    }

    @Override
    public void applyTo(MessageDecoder decoder, Connection sender) {
        decoder.handleStreamDataComplete(this, sender);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        StreamDataCompleteMessage p = (StreamDataCompleteMessage)o;
        if (this.sourceStreamID != p.sourceStreamID) {
            return false;
        }
        return this.destStreamID == p.destStreamID;
    }

    @Override
    public String toString() {
        return super.toString() + " srcId=" + this.sourceStreamID + " dstId=" + this.destStreamID;
    }

    @Override
    public MessageTypeIdentifier getEMTI() {
        return MessageTypeIdentifier.StreamDataComplete;
    }
}

