/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb;

import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.openlcb.AddressedMessage;
import org.openlcb.Connection;
import org.openlcb.MessageDecoder;
import org.openlcb.NodeID;

@Immutable
@ThreadSafe
public class StreamDataSendMessage
extends AddressedMessage {
    int[] data;
    byte destStreamID;

    public StreamDataSendMessage(NodeID source, NodeID dest, byte destStreamID, int[] data) {
        super(source, dest);
        this.data = data;
        this.destStreamID = destStreamID;
    }

    public byte getDestinationStreamID() {
        return this.destStreamID;
    }

    public int[] getData() {
        return this.data;
    }

    @Override
    public void applyTo(MessageDecoder decoder, Connection sender) {
        decoder.handleStreamDataSend(this, sender);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        StreamDataSendMessage p = (StreamDataSendMessage)o;
        if (this.data.length != p.data.length) {
            return false;
        }
        if (this.destStreamID != p.destStreamID) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public String toString() {
        StringBuilder value = new StringBuilder(super.toString());
        value.append(" Stream with dst ID " + Integer.toString(this.destStreamID & 0xFF) + ": ");
        int n = this.data.length;
        if (n > 16) {
            n = 16;
        }
        boolean first = true;
        for (int i = 0; i < n; ++i) {
            if (!first) {
                value.append(".");
            }
            value.append(Integer.toHexString(this.data[i] & 0xFF).toUpperCase());
            first = false;
        }
        if (this.data.length > 16) {
            value.append(" ...");
        }
        return new String(value);
    }

    @Override
    public int getMTI() {
        return 5780;
    }
}

