/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb;

import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.openlcb.AddressedPayloadMessage;
import org.openlcb.Connection;
import org.openlcb.MessageDecoder;
import org.openlcb.MessageTypeIdentifier;
import org.openlcb.NodeID;
import org.openlcb.Utilities;

@Immutable
@ThreadSafe
public class StreamInitiateReplyMessage
extends AddressedPayloadMessage {
    int bufferSize;
    byte sourceStreamID;
    byte destStreamID;

    public StreamInitiateReplyMessage(NodeID source, NodeID dest, int bufferSize, byte sourceStreamID, byte destStreamID) {
        super(source, dest, StreamInitiateReplyMessage.toPayload(bufferSize, sourceStreamID, destStreamID));
        this.bufferSize = bufferSize;
        this.sourceStreamID = sourceStreamID;
        this.destStreamID = destStreamID;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public byte getDestinationStreamID() {
        return this.destStreamID;
    }

    public byte getSourceStreamID() {
        return this.sourceStreamID;
    }

    static byte[] toPayload(int bufferSize, byte sourceStreamID, byte destStreamID) {
        byte[] b = new byte[]{0, 0, 0, 0, sourceStreamID, destStreamID};
        Utilities.HostToNetworkUint16(b, 0, bufferSize);
        return b;
    }

    @Override
    public void applyTo(MessageDecoder decoder, Connection sender) {
        decoder.handleStreamInitiateReply(this, sender);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        StreamInitiateReplyMessage p = (StreamInitiateReplyMessage)o;
        if (this.bufferSize != p.bufferSize) {
            return false;
        }
        if (this.sourceStreamID != p.sourceStreamID) {
            return false;
        }
        if (this.destStreamID != p.destStreamID) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public String toString() {
        return super.toString() + " SSID " + this.sourceStreamID + " DSID " + this.destStreamID + " bsize " + this.bufferSize;
    }

    @Override
    public MessageTypeIdentifier getEMTI() {
        return MessageTypeIdentifier.StreamInitiateReply;
    }
}

