/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb;

import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.openlcb.AddressedPayloadMessage;
import org.openlcb.Connection;
import org.openlcb.MessageDecoder;
import org.openlcb.MessageTypeIdentifier;
import org.openlcb.NodeID;
import org.openlcb.Utilities;

@Immutable
@ThreadSafe
public class StreamInitiateRequestMessage
extends AddressedPayloadMessage {
    int bufferSize;
    byte sourceStreamID;
    byte destinationStreamID;

    public StreamInitiateRequestMessage(NodeID source, NodeID dest, int bufferSize, byte sourceStreamID, byte destinationStreamID) {
        super(source, dest, StreamInitiateRequestMessage.toPayload(bufferSize, sourceStreamID, destinationStreamID));
        this.bufferSize = bufferSize;
        this.sourceStreamID = sourceStreamID;
        this.destinationStreamID = destinationStreamID;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public byte getSourceStreamID() {
        return this.sourceStreamID;
    }

    public byte getDestinationStreamID() {
        return this.destinationStreamID;
    }

    static byte[] toPayload(int bufferSize, byte sourceStreamID, byte destStreamID) {
        byte[] b = new byte[]{0, 0, 0, 0, sourceStreamID, destStreamID};
        Utilities.HostToNetworkUint16(b, 0, bufferSize);
        return b;
    }

    @Override
    public void applyTo(MessageDecoder decoder, Connection sender) {
        decoder.handleStreamInitiateRequest(this, sender);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        StreamInitiateRequestMessage p = (StreamInitiateRequestMessage)o;
        if (this.bufferSize != p.bufferSize) {
            return false;
        }
        if (this.sourceStreamID != p.sourceStreamID) {
            return false;
        }
        if (this.destinationStreamID != p.destinationStreamID) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public String toString() {
        return super.toString() + " SSID " + this.sourceStreamID + " DSID " + this.destinationStreamID + " bsize " + this.bufferSize;
    }

    @Override
    public MessageTypeIdentifier getEMTI() {
        return MessageTypeIdentifier.StreamInitiateRequest;
    }

    @Override
    public int getMTI() {
        return 5348;
    }
}

