/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb;

import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.openlcb.AddressedPayloadMessage;
import org.openlcb.Connection;
import org.openlcb.MessageDecoder;
import org.openlcb.MessageTypeIdentifier;
import org.openlcb.NodeID;

@Immutable
@ThreadSafe
public class UnknownMtiMessage
extends AddressedPayloadMessage {
    int originalMTI;

    public UnknownMtiMessage(NodeID source, NodeID dest, int originalMTI, byte[] content) {
        super(source, dest, content);
        this.originalMTI = originalMTI;
    }

    public int getOriginalMTI() {
        return this.originalMTI;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof UnknownMtiMessage) {
            return this.equals((UnknownMtiMessage)o);
        }
        return false;
    }

    public boolean equals(UnknownMtiMessage o) {
        if (o == null || this.originalMTI != o.getOriginalMTI()) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public void applyTo(MessageDecoder decoder, Connection sender) {
        decoder.handleUnknownMTI(this, sender);
    }

    @Override
    public String toString() {
        StringBuilder value = new StringBuilder(super.toString());
        value.append(" Unknown MTI message for MTI 0x");
        value.append(Integer.toHexString(this.getOriginalMTI() & 0xFFF).toUpperCase());
        return new String(value);
    }

    @Override
    public MessageTypeIdentifier getEMTI() {
        return MessageTypeIdentifier.UnknownMTI;
    }
}

