/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb;

import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.openlcb.Connection;
import org.openlcb.Message;
import org.openlcb.MessageDecoder;
import org.openlcb.NodeID;

@Immutable
@ThreadSafe
public class VerifiedNodeIDNumberMessage
extends Message {
    final boolean hasSimpleProtocol;

    public VerifiedNodeIDNumberMessage(NodeID source) {
        super(source);
        this.hasSimpleProtocol = false;
    }

    public VerifiedNodeIDNumberMessage(NodeID source, boolean hasSimpleProtocol) {
        super(source);
        this.hasSimpleProtocol = hasSimpleProtocol;
    }

    public boolean hasSimpleProtocol() {
        return this.hasSimpleProtocol;
    }

    @Override
    public void applyTo(MessageDecoder decoder, Connection sender) {
        decoder.handleVerifiedNodeIDNumber(this, sender);
    }

    @Override
    public String toString() {
        return super.toString() + " Verified Node ID Number" + (this.hasSimpleProtocol() ? " with Simple Protocol" : "");
    }

    @Override
    public int getMTI() {
        return MTI_VERIFIED_NID;
    }
}

