/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.can;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.openlcb.NodeID;
import org.openlcb.can.OpenLcbCanFrame;

public class AliasMap {
    HashMap<NodeID, Integer> iMap = new HashMap();
    HashMap<Integer, NodeID> nMap = new HashMap();
    HashMap<Integer, NodeID> localAliases = new HashMap();
    List<Watcher> watchers = new ArrayList<Watcher>();
    private static final Logger logger = Logger.getLogger(AliasMap.class.getName());

    public synchronized void addWatcher(Watcher w) {
        this.watchers.add(w);
    }

    public void processFrame(OpenLcbCanFrame f) {
        if (f.isInitializationComplete() || f.isVerifiedNID() || f.isAliasMapDefinition()) {
            if (f.data.length >= 6) {
                Integer alias = f.getSourceAlias();
                NodeID nid = f.getNodeID();
                this.insert(alias, nid);
            }
        } else if (f.isAliasMapReset()) {
            Integer alias = f.getSourceAlias();
            this.remove(alias);
        } else if (f.isAliasMapEnquiry() && f.length == 0) {
            this.iMap = new HashMap();
            this.nMap = new HashMap();
            for (int alias : this.localAliases.keySet()) {
                NodeID nid = this.localAliases.get(alias);
                this.nMap.put(alias, nid);
                this.iMap.put(nid, alias);
            }
        }
    }

    public void insertLocalAlias(int alias, NodeID nid) {
        this.localAliases.put(alias, nid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(int alias, NodeID nid) {
        AliasMap aliasMap = this;
        synchronized (aliasMap) {
            if (this.nMap.containsKey(alias) && nid.toLong() != this.nMap.get(alias).toLong()) {
                logger.warning("map contains alias " + String.format("0x%03X", alias & 0xFFF) + " for node " + this.nMap.get(alias) + " change to " + nid);
            }
            if (this.iMap.containsKey(nid) && alias != this.iMap.get(nid)) {
                logger.warning("map contains nodeID " + nid + " for alias " + String.format("0x%03X", this.iMap.get(nid) & 0xFFF) + " change to " + String.format("0x%03X", alias & 0xFFF));
            }
            this.nMap.put(alias, nid);
            this.iMap.put(nid, alias);
        }
        for (Watcher w : this.watchers) {
            w.aliasAdded(nid, alias);
        }
    }

    public synchronized void remove(int alias) {
        NodeID nid = this.getNodeID(alias);
        if (nid == null) {
            return;
        }
        this.nMap.remove(alias);
        this.iMap.remove(nid);
    }

    public synchronized NodeID getNodeID(int alias) {
        NodeID retVal = this.nMap.get(alias);
        if (retVal != null) {
            return retVal;
        }
        return new NodeID();
    }

    public synchronized int getAlias(NodeID nid) {
        Integer r = this.iMap.get(nid);
        if (r == null) {
            return -1;
        }
        return r;
    }

    public static interface Watcher {
        public void aliasAdded(NodeID var1, int var2);
    }
}

