/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.can;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.openlcb.Connection;
import org.openlcb.Message;
import org.openlcb.NodeID;
import org.openlcb.OlcbInterface;
import org.openlcb.OlcbThreadFactory;
import org.openlcb.can.AliasMap;
import org.openlcb.can.CanFrame;
import org.openlcb.can.CanFrameListener;
import org.openlcb.can.MessageBuilder;
import org.openlcb.can.NIDaAlgorithm;
import org.openlcb.can.OpenLcbCanFrame;

public class CanInterface {
    private static final Logger logger = Logger.getLogger(CanInterface.class.getName());
    private final AliasMap aliasMap;
    private final MessageBuilder messageBuilder;
    private final CanFrameListener frameOutput;
    private final FrameParser frameInput;
    private final OlcbInterface olcbInterface;
    private final FrameRenderer frameRenderer;
    private final List<Connection.ConnectionListener> listeners = new ArrayList<Connection.ConnectionListener>();
    private final NodeID nodeId;
    private final NIDaAlgorithm aliasWatcher;
    protected boolean initialized = false;
    private ThreadPoolExecutor threadPool = null;
    static final int minThreads = 10;
    static final int maxThreads = 10;
    static final long threadTimeout = 10L;

    public CanInterface(NodeID interfaceId, CanFrameListener frameOutput) {
        this(interfaceId, frameOutput, new ThreadPoolExecutor(10, 10, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new OlcbThreadFactory()));
        this.threadPool.allowCoreThreadTimeOut(true);
    }

    public CanInterface(NodeID interfaceId, CanFrameListener frameOutput, ThreadPoolExecutor tpe) {
        this.threadPool = tpe;
        this.frameOutput = frameOutput;
        this.frameRenderer = new FrameRenderer();
        this.nodeId = interfaceId;
        this.olcbInterface = new OlcbInterface(this.nodeId, this.frameRenderer, this.threadPool);
        this.aliasMap = new AliasMap();
        this.messageBuilder = new MessageBuilder(this.aliasMap);
        this.aliasWatcher = new NIDaAlgorithm(interfaceId, frameOutput);
        this.frameInput = new FrameParser();
        this.threadPool.execute(new Runnable(){

            @Override
            public void run() {
                CanInterface.this.initialize();
            }
        });
    }

    public CanFrameListener frameInput() {
        return this.frameInput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStartListener(Connection.ConnectionListener l) {
        List<Connection.ConnectionListener> list = this.listeners;
        synchronized (list) {
            if (!this.initialized) {
                this.listeners.add(l);
                return;
            }
        }
        l.connectionActive(this.frameRenderer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        final Semaphore sema = new Semaphore(1, true);
        sema.acquireUninterruptibly();
        this.aliasWatcher.start(new Runnable(){

            @Override
            public void run() {
                sema.release();
            }
        });
        try {
            sema.acquire();
        }
        catch (InterruptedException e) {
            return;
        }
        OpenLcbCanFrame gReqFrame = new OpenLcbCanFrame(this.aliasWatcher.getNIDa());
        gReqFrame.setVerifyNID(null);
        this.frameOutput.send(gReqFrame);
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            return;
        }
        this.aliasMap.insert(this.aliasWatcher.getNIDa(), this.nodeId);
        this.aliasMap.insertLocalAlias(this.aliasWatcher.getNIDa(), this.nodeId);
        ArrayList<Connection.ConnectionListener> listeners_copy = new ArrayList<Connection.ConnectionListener>();
        List<Connection.ConnectionListener> list = this.listeners;
        synchronized (list) {
            this.initialized = true;
            listeners_copy.addAll(this.listeners);
            this.listeners.clear();
        }
        for (Connection.ConnectionListener l : listeners_copy) {
            l.connectionActive(this.frameRenderer);
        }
    }

    public OlcbInterface getInterface() {
        return this.olcbInterface;
    }

    public void dispose() {
        this.aliasWatcher.dispose();
        if (this.threadPool != null && !this.threadPool.isShutdown()) {
            this.threadPool.shutdown();
            try {
                if (!this.threadPool.awaitTermination(10L, TimeUnit.MILLISECONDS)) {
                    this.threadPool.shutdownNow();
                    if (!this.threadPool.awaitTermination(10L, TimeUnit.SECONDS)) {
                        logger.warning("Pool did not terminate");
                    }
                }
            }
            catch (InterruptedException ie) {
                this.threadPool.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
        this.threadPool = null;
    }

    class FrameRenderer
    implements Connection {
        FrameRenderer() {
        }

        @Override
        public void put(Message msg, Connection sender) {
            List<OpenLcbCanFrame> l = CanInterface.this.messageBuilder.processMessage(msg);
            for (CanFrame canFrame : l) {
                CanInterface.this.frameOutput.send(canFrame);
            }
        }

        @Override
        public void registerStartNotification(Connection.ConnectionListener c) {
            CanInterface.this.addStartListener(c);
        }
    }

    class FrameParser
    implements CanFrameListener {
        FrameParser() {
        }

        @Override
        public void send(CanFrame frame) {
            CanInterface.this.aliasWatcher.send(frame);
            CanInterface.this.aliasMap.processFrame(new OpenLcbCanFrame(frame));
            List<Message> l = CanInterface.this.messageBuilder.processFrame(frame);
            if (CanInterface.this.messageBuilder.foundUnblockedMessage()) {
                CanInterface.this.olcbInterface.getOutputConnection().put(CanInterface.this.messageBuilder.getTriggerMessage(), null);
            }
            if (l == null) {
                return;
            }
            for (Message m : l) {
                CanInterface.this.olcbInterface.getInputConnection().put(m, null);
            }
        }
    }
}

