/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.can;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.openlcb.can.CanFrame;
import org.openlcb.implementations.DatagramUtils;

public class GridConnect {
    private static final Logger logger = Logger.getLogger(GridConnect.class.getName());

    public static String format(CanFrame frame) {
        StringBuilder b = new StringBuilder();
        if (frame.isExtended()) {
            b.append(String.format(":X%08X", frame.getHeader()));
        } else {
            b.append(String.format(":S%03X", frame.getHeader()));
        }
        if (frame.isRtr()) {
            b.append('R');
        } else {
            b.append('N');
        }
        if (frame.getNumDataElements() > 8) {
            logger.warning("Output frame with too many data elements: " + Integer.toString(frame.getNumDataElements()));
        }
        for (int i = 0; i < frame.getNumDataElements(); ++i) {
            b.append(String.format("%02X", frame.getElement(i) & 0xFF));
        }
        b.append(';');
        return b.toString();
    }

    public static List<CanFrame> parse(String data) {
        final ArrayList<CanFrame> l = new ArrayList<CanFrame>();
        Input parser = new Input(){

            @Override
            public void onFrame(CanFrame f) {
                l.add(f);
            }
        };
        parser.send(data);
        return l;
    }

    public static abstract class Input {
        private boolean isExtended;
        private int header;
        private boolean isRtr;
        private InputState state = InputState.NOPACKET;
        private ArrayList<Byte> data = new ArrayList(8);
        private byte currData;

        public void send(String data) {
            for (int i = 0; i < data.length(); ++i) {
                this.send(data.charAt(i));
            }
        }

        public void send(char c) {
            block8: while (true) {
                switch (this.state) {
                    case NOPACKET: {
                        if (c == ':') {
                            this.state = InputState.EXTENDED;
                        }
                        return;
                    }
                    case EXTENDED: {
                        if (c == 'X') {
                            this.isExtended = true;
                        } else if (c == 'S') {
                            this.isExtended = false;
                        } else {
                            logger.fine("Unknown gridconnect type character: " + c);
                            this.state = InputState.NOPACKET;
                            return;
                        }
                        this.state = InputState.HEADER;
                        this.header = 0;
                        return;
                    }
                    case HEADER: {
                        int dvalue = Character.digit(c, 16);
                        if (dvalue >= 0) {
                            this.header <<= 4;
                            this.header |= dvalue;
                            return;
                        }
                        this.state = InputState.REMOTE;
                        continue block8;
                    }
                    case REMOTE: {
                        if (c == 'N') {
                            this.isRtr = false;
                        } else if (c == 'R') {
                            this.isRtr = true;
                        } else {
                            logger.fine("Unknown gridconnect remote character: " + c);
                            this.state = InputState.NOPACKET;
                            continue block8;
                        }
                        this.state = InputState.BODYHI_OR_END;
                        this.data.clear();
                        return;
                    }
                    case BODYHI_OR_END: {
                        if (c == ';') {
                            this.onFrame(new RawCanFrame(this.isExtended, this.header, this.isRtr, this.data));
                            this.state = InputState.NOPACKET;
                            return;
                        }
                        int dvalue = Character.digit(c, 16);
                        if (dvalue < 0) {
                            logger.fine("Unknown gridconnect data character: " + c);
                            this.state = InputState.NOPACKET;
                            continue block8;
                        }
                        this.currData = (byte)(dvalue << 4);
                        this.state = InputState.BODYLO;
                        return;
                    }
                    case BODYLO: {
                        int dvalue = Character.digit(c, 16);
                        if (dvalue < 0) {
                            logger.fine("Unknown gridconnect data character: " + c);
                            this.state = InputState.NOPACKET;
                            continue block8;
                        }
                        this.currData = (byte)(this.currData | dvalue & 0xF);
                        this.data.add(this.currData);
                        this.state = InputState.BODYHI_OR_END;
                        return;
                    }
                }
            }
        }

        public abstract void onFrame(CanFrame var1);
    }

    static class RawCanFrame
    implements CanFrame {
        private boolean isExtended;
        private boolean isRtr;
        private int header;
        private int len;
        private byte[] data;

        public RawCanFrame(boolean isExtended, int header, boolean isRtr, ArrayList<Byte> data) {
            this.isExtended = isExtended;
            this.header = header;
            this.isRtr = isRtr;
            this.len = data.size();
            this.data = new byte[this.len];
            for (int i = 0; i < this.len; ++i) {
                this.data[i] = data.get(i);
            }
        }

        @Override
        public int getHeader() {
            return this.header;
        }

        @Override
        public boolean isExtended() {
            return this.isExtended;
        }

        @Override
        public boolean isRtr() {
            return this.isRtr;
        }

        @Override
        public int getNumDataElements() {
            return this.len;
        }

        @Override
        public int getElement(int n) {
            return DatagramUtils.byteToInt(this.data[n]);
        }

        @Override
        public long bodyAsLong() {
            long retval = 0L;
            for (int i = 0; i < this.data.length; ++i) {
                retval = retval << 8 | (long)(this.data[i] & 0xFF);
            }
            return retval;
        }

        @Override
        public long dataAsLong() {
            long retval = 0L;
            for (int i = 2; i < this.data.length; ++i) {
                retval = retval << 8 | (long)(this.data[i] & 0xFF);
            }
            return retval;
        }

        @Override
        public byte[] getData() {
            byte[] b = new byte[this.len];
            System.arraycopy(this.data, 0, b, 0, this.len);
            return b;
        }
    }

    static enum InputState {
        NOPACKET,
        EXTENDED,
        HEADER,
        REMOTE,
        BODYHI_OR_END,
        BODYLO;

    }
}

